/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.elasticsearch;

import java.io.File;
import java.nio.file.Paths;
import java.util.Dictionary;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.elasticsearch", immediate=true)
public class EmbeddedNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedNode.class);
    private static Node node;
    public static String PLUGINS_DIRECTORY;
    public static String ELASTIC_YAML_FILE;
    public static String CLUSTER_NAME;
    public static String HTTP_ENABLED;
    public static String NODE_NAME;
    public static String PATH_DATA;
    public static String PATH_HOME;
    public static String NETWORK_HOST;
    public static String CLUSTER_ROUTING_SCHEDULE;
    public static String PATH_PLUGINS;
    public static String HTTP_CORS_ENABLED;
    public static String HTTP_CORS_ALLOW_ORIGIN;
    public static String INDEX_MAX_RESULT_WINDOW;
    private static final boolean IS_WINDOWS;

    @Activate
    public void acticate(ComponentContext context) throws Exception {
        this.start(context.getProperties());
    }

    public void start(Dictionary<String, ?> config) throws Exception {
        LOGGER.info("Starting Elasticsearch node ...");
        LOGGER.debug("Creating elasticsearch settings");
        String karafHome = System.getProperty("karaf.home");
        File pluginsFile = new File(this.getConfig(config, null, PLUGINS_DIRECTORY, new File(new File(karafHome), "/elasticsearch/plugins").getAbsolutePath()));
        LOGGER.debug("Elasticsearch plugins folder: {}", (Object)pluginsFile.getAbsolutePath());
        File ymlFile = new File(this.getConfig(config, null, ELASTIC_YAML_FILE, new File(System.getProperty("karaf.etc"), "elasticsearch.yml").getAbsolutePath()));
        LOGGER.debug("Eleasticsearch yml configuration: {}", (Object)ymlFile.getAbsolutePath());
        Settings settings = null;
        if (ymlFile.exists()) {
            LOGGER.debug("elasticsearch.yml found for settings");
            settings = Settings.settingsBuilder().loadFromPath(Paths.get(ymlFile.toURI())).build();
        }
        LOGGER.debug("enhancing elasticsearch configuration with given configurations");
        Settings.Builder settingsBuilder = Settings.settingsBuilder();
        if (settings != null) {
            settingsBuilder = Settings.settingsBuilder().put(settings);
        }
        settingsBuilder.put(CLUSTER_NAME, this.getConfig(config, settings, CLUSTER_NAME, "elasticsearch"));
        settingsBuilder.put(HTTP_ENABLED, this.getConfig(config, settings, HTTP_ENABLED, "true"));
        settingsBuilder.put(PATH_DATA, this.getConfig(config, settings, PATH_DATA, "data"));
        settingsBuilder.put(PATH_HOME, this.getConfig(config, settings, PATH_HOME, "data"));
        settingsBuilder.put(NODE_NAME, this.getConfig(config, settings, NODE_NAME, this.getNodeName()));
        settingsBuilder.put(NETWORK_HOST, this.getConfig(config, settings, NETWORK_HOST, "127.0.0.1"));
        settingsBuilder.put(CLUSTER_ROUTING_SCHEDULE, this.getConfig(config, settings, CLUSTER_ROUTING_SCHEDULE, "50ms"));
        if (!IS_WINDOWS) {
            String pluginsPath = pluginsFile.getAbsolutePath();
            settingsBuilder.put(PATH_PLUGINS, this.getConfig(config, settings, PATH_PLUGINS, pluginsPath));
        }
        settingsBuilder.put(HTTP_CORS_ENABLED, this.getConfig(config, settings, HTTP_CORS_ENABLED, "true"));
        settingsBuilder.put(HTTP_CORS_ALLOW_ORIGIN, this.getConfig(config, settings, HTTP_CORS_ALLOW_ORIGIN, "/.*/"));
        settingsBuilder.put(INDEX_MAX_RESULT_WINDOW, this.getConfig(config, settings, INDEX_MAX_RESULT_WINDOW, "2147483647"));
        LOGGER.debug("Creating the elasticsearch node");
        node = NodeBuilder.nodeBuilder().settings(settingsBuilder).build();
        LOGGER.info("Elasticsearch node created");
        if (node != null) {
            node.start();
        }
    }

    private String getNodeName() {
        return System.getProperty("karaf.name") == null ? "decanter" : System.getProperty("karaf.name");
    }

    @Deactivate
    public void stop() throws Exception {
        if (node != null) {
            node.close();
        }
    }

    public boolean isStarted() throws Exception {
        if (node != null) {
            return !node.isClosed();
        }
        return false;
    }

    public Node getNode() {
        return node;
    }

    private String getConfig(Dictionary<String, ?> config, Settings settings, String key, String defaultValue) {
        if (settings != null && settings.get(key) != null) {
            defaultValue = settings.get(key);
        }
        if (config == null) {
            return defaultValue;
        }
        String value = (String)config.get(key);
        return value != null ? value : defaultValue;
    }

    static {
        PLUGINS_DIRECTORY = "plugins.directory";
        ELASTIC_YAML_FILE = "elasticsearch.yaml";
        CLUSTER_NAME = "cluster.name";
        HTTP_ENABLED = "http.enabled";
        NODE_NAME = "node.name";
        PATH_DATA = "path.data";
        PATH_HOME = "path.home";
        NETWORK_HOST = "network.host";
        CLUSTER_ROUTING_SCHEDULE = "cluster.routing.schedule";
        PATH_PLUGINS = "path.plugins";
        HTTP_CORS_ENABLED = "http.cors.enabled";
        HTTP_CORS_ALLOW_ORIGIN = "http.cors.allow-origin";
        INDEX_MAX_RESULT_WINDOW = "index.max_result_window";
        IS_WINDOWS = System.getProperty("os.name").contains("indow");
    }
}

