/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.elasticsearch;

import java.io.File;
import java.util.Dictionary;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.elasticsearch", immediate=true)
public class EmbeddedNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedNode.class);
    private static Node node;
    public static String PLUGINS_DIRECTORY;
    public static String ELASTIC_YAML_FILE;
    public static String CLUSTER_NAME;
    public static String HTTP_ENABLED;
    public static String NODE_DATA;
    public static String NODE_NAME;
    public static String NODE_MASTER;
    public static String PATH_DATA;
    public static String NETWORK_HOST;
    public static String PORT;
    public static String CLUSTER_ROUTING_SCHEDULE;
    public static String PATH_PLUGINS;
    public static String HTTP_CORS_ENABLED;
    public static String HTTP_CORS_ALLOW_ORIGIN;
    private static final boolean IS_WINDOWS;

    @Activate
    public void acticate(ComponentContext context) throws Exception {
        this.start(context.getProperties());
    }

    public void start(Dictionary<String, ?> config) throws Exception {
        LOGGER.info("Starting Elasticsearch node ...");
        LOGGER.debug("Creating elasticsearch settings");
        String karafHome = System.getProperty("karaf.home");
        String defaultPluginsPath = new File(new File(karafHome), "/elasticsearch/plugins").getAbsolutePath();
        File pluginsFile = new File((String)this.getConfig(config, null, PLUGINS_DIRECTORY, defaultPluginsPath));
        LOGGER.debug("Elasticsearch plugins folder: {}", (Object)pluginsFile.getAbsolutePath());
        String defaultConfigPath = new File(System.getProperty("karaf.etc"), "elasticsearch.yml").getAbsolutePath();
        File ymlFile = new File((String)this.getConfig(config, null, ELASTIC_YAML_FILE, defaultConfigPath));
        LOGGER.debug("Eleasticsearch yml configuration: {}", (Object)ymlFile.getAbsolutePath());
        Settings settings = null;
        if (ymlFile.exists()) {
            LOGGER.debug("elasticsearch.yml found for settings");
            settings = ImmutableSettings.settingsBuilder().loadFromUrl(ymlFile.toURI().toURL()).build();
        }
        LOGGER.debug("enhancing elasticsearch configuration with given configurations");
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        if (settings != null) {
            settingsBuilder = ImmutableSettings.settingsBuilder().put(settings);
        }
        settingsBuilder.put(new Object[]{CLUSTER_NAME, this.getConfig(config, settings, CLUSTER_NAME, "elasticsearch")});
        settingsBuilder.put(new Object[]{HTTP_ENABLED, this.getConfig(config, settings, HTTP_ENABLED, "true")});
        settingsBuilder.put(new Object[]{PATH_DATA, this.getConfig(config, settings, PATH_DATA, "data")});
        settingsBuilder.put(new Object[]{NODE_MASTER, this.getConfig(config, settings, NODE_MASTER, "true")});
        settingsBuilder.put(new Object[]{NODE_DATA, this.getConfig(config, settings, NODE_DATA, "true")});
        settingsBuilder.put(new Object[]{NODE_NAME, this.getConfig(config, settings, NODE_NAME, this.getNodeName())});
        settingsBuilder.put(new Object[]{NETWORK_HOST, this.getConfig(config, settings, NETWORK_HOST, "127.0.0.1")});
        settingsBuilder.put(new Object[]{PORT, this.getConfig(config, settings, PORT, 9300)});
        settingsBuilder.put(new Object[]{CLUSTER_ROUTING_SCHEDULE, this.getConfig(config, settings, CLUSTER_ROUTING_SCHEDULE, "50ms")});
        if (!IS_WINDOWS) {
            settingsBuilder.put(new Object[]{PATH_PLUGINS, this.getConfig(config, settings, PATH_PLUGINS, pluginsFile.getAbsolutePath())});
        }
        settingsBuilder.put(new Object[]{HTTP_CORS_ENABLED, this.getConfig(config, settings, HTTP_CORS_ENABLED, "true")});
        settingsBuilder.put(new Object[]{HTTP_CORS_ALLOW_ORIGIN, this.getConfig(config, settings, HTTP_CORS_ALLOW_ORIGIN, "/.*/")});
        LOGGER.debug("Creating the elasticsearch node");
        settingsBuilder.classLoader(Settings.class.getClassLoader());
        node = new InternalNode(settingsBuilder.build(), false);
        LOGGER.info("Elasticsearch node created");
        if (node != null) {
            node.start();
        }
    }

    private String getNodeName() {
        return System.getProperty("karaf.name") == null ? "decanter" : System.getProperty("karaf.name");
    }

    @Deactivate
    public void stop() throws Exception {
        if (node != null) {
            node.close();
        }
    }

    public boolean isStarted() throws Exception {
        if (node != null) {
            return !node.isClosed();
        }
        return false;
    }

    public Node getNode() {
        return node;
    }

    private Object getConfig(Dictionary<String, ?> config, Settings settings, String key, Object defaultValue) {
        if (settings != null && settings.get(key) != null) {
            defaultValue = settings.get(key);
        }
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(key);
        return value != null ? value : defaultValue;
    }

    static {
        PLUGINS_DIRECTORY = "plugins.directory";
        ELASTIC_YAML_FILE = "elasticsearch.yaml";
        CLUSTER_NAME = "cluster.name";
        HTTP_ENABLED = "http.enabled";
        NODE_DATA = "node.data";
        NODE_NAME = "node.name";
        NODE_MASTER = "node.master";
        PATH_DATA = "path.data";
        NETWORK_HOST = "network.host";
        PORT = "port";
        CLUSTER_ROUTING_SCHEDULE = "cluster.routing.schedule";
        PATH_PLUGINS = "path.plugins";
        HTTP_CORS_ENABLED = "http.cors.enabled";
        HTTP_CORS_ALLOW_ORIGIN = "http.cors.allow-origin";
        IS_WINDOWS = System.getProperty("os.name").contains("indow");
    }
}

