/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.springstate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;

public class SpringApplicationListener
implements OsgiBundleApplicationContextListener,
BundleListener,
BundleStateService {
    private static final Logger LOG = LoggerFactory.getLogger(SpringApplicationListener.class);
    private final Map<Long, OsgiBundleApplicationContextEvent> states = new ConcurrentHashMap<Long, OsgiBundleApplicationContextEvent>();

    public SpringApplicationListener(BundleContext bundleContext) {
    }

    public String getName() {
        return "Spring DM";
    }

    public BundleState getState(Bundle bundle) {
        OsgiBundleApplicationContextEvent event = this.states.get(bundle.getBundleId());
        BundleState state = this.mapEventToState(event);
        return bundle.getState() != 32 ? BundleState.Unknown : state;
    }

    public String getDiag(Bundle bundle) {
        return null;
    }

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        if (LOG.isDebugEnabled()) {
            BundleState state = this.mapEventToState(event);
            LOG.debug("Spring app state changed to " + state + " for bundle " + event.getBundle().getBundleId());
        }
        this.states.put(event.getBundle().getBundleId(), event);
    }

    private BundleState mapEventToState(OsgiBundleApplicationContextEvent event) {
        if (event == null) {
            return BundleState.Unknown;
        }
        if (event instanceof BootstrappingDependencyEvent) {
            return BundleState.Waiting;
        }
        if (event instanceof OsgiBundleContextFailedEvent) {
            return BundleState.Failure;
        }
        if (event instanceof OsgiBundleContextRefreshedEvent) {
            return BundleState.Active;
        }
        return BundleState.Unknown;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.states.remove(event.getBundle().getBundleId());
        }
    }
}

