/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.TopicsSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class TopicsSpecTest {
    private static final TopicsSpec FOO = new TopicsSpec();
    private static final PartitionsSpec PARTSA = new PartitionsSpec(3, 3, null, null);
    private static final PartitionsSpec PARTSB;

    @Test
    public void testMaterialize() {
        Map parts = FOO.materialize();
        Assertions.assertTrue((boolean)parts.containsKey("topicA0"));
        Assertions.assertTrue((boolean)parts.containsKey("topicA1"));
        Assertions.assertTrue((boolean)parts.containsKey("topicA2"));
        Assertions.assertTrue((boolean)parts.containsKey("topicB"));
        Assertions.assertEquals((int)4, (int)parts.keySet().size());
        Assertions.assertEquals((Object)PARTSA, parts.get("topicA0"));
        Assertions.assertEquals((Object)PARTSA, parts.get("topicA1"));
        Assertions.assertEquals((Object)PARTSA, parts.get("topicA2"));
        Assertions.assertEquals((Object)PARTSB, parts.get("topicB"));
    }

    @Test
    public void testPartitionNumbers() {
        List partsANumbers = PARTSA.partitionNumbers();
        Assertions.assertEquals((Integer)0, (Integer)((Integer)partsANumbers.get(0)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)partsANumbers.get(1)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)partsANumbers.get(2)));
        Assertions.assertEquals((int)3, (int)partsANumbers.size());
        List partsBNumbers = PARTSB.partitionNumbers();
        Assertions.assertEquals((Integer)0, (Integer)((Integer)partsBNumbers.get(0)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)partsBNumbers.get(1)));
        Assertions.assertEquals((int)2, (int)partsBNumbers.size());
    }

    @Test
    public void testPartitionsSpec() throws Exception {
        String text = "{\"numPartitions\": 5, \"configs\": {\"foo\": \"bar\"}}";
        PartitionsSpec spec = (PartitionsSpec)JsonUtil.JSON_SERDE.readValue(text, PartitionsSpec.class);
        Assertions.assertEquals((int)5, (int)spec.numPartitions());
        Assertions.assertEquals((Object)"bar", spec.configs().get("foo"));
        Assertions.assertEquals((int)1, (int)spec.configs().size());
    }

    static {
        FOO.set("topicA[0-2]", PARTSA);
        HashMap<Integer, List<Integer>> assignmentsB = new HashMap<Integer, List<Integer>>();
        assignmentsB.put(0, Arrays.asList(0, 1, 2));
        assignmentsB.put(1, Arrays.asList(2, 3, 4));
        PARTSB = new PartitionsSpec(0, 0, assignmentsB, null);
        FOO.set("topicB", PARTSB);
    }
}

