/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.trogdor.workload.ShareConsumeBenchSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShareConsumeBenchSpecTest {
    ShareConsumeBenchSpecTest() {
    }

    @Test
    public void testExpandTopicNames() {
        ShareConsumeBenchSpec shareConsumeBenchSpec = this.shareConsumeBenchSpec(Arrays.asList("foo[1-3]", "bar"));
        HashSet<String> expectedNames = new HashSet<String>();
        expectedNames.add("foo1");
        expectedNames.add("foo2");
        expectedNames.add("foo3");
        expectedNames.add("bar");
        Assertions.assertEquals(expectedNames, (Object)shareConsumeBenchSpec.expandTopicNames());
    }

    @Test
    public void testInvalidNameRaisesException() {
        for (String invalidName : Arrays.asList("In:valid", "invalid:", ":invalid[]", "in:valid:", "invalid[1-3]:")) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.shareConsumeBenchSpec(Collections.singletonList(invalidName)).expandTopicNames());
        }
    }

    private ShareConsumeBenchSpec shareConsumeBenchSpec(List<String> activeTopics) {
        return new ShareConsumeBenchSpec(0L, 0L, "node", "localhost", 123, 1234L, "sg-1", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Integer.valueOf(1), Optional.empty(), activeTopics);
    }
}

