/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import org.apache.kafka.trogdor.workload.Histogram;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HistogramTest {
    private static Histogram createHistogram(int maxValue, int ... values) {
        Histogram histogram = new Histogram(maxValue);
        for (int value : values) {
            histogram.add(value);
        }
        return histogram;
    }

    @Test
    public void testHistogramAverage() {
        Histogram empty = HistogramTest.createHistogram(1, new int[0]);
        Assertions.assertEquals((int)0, (int)((int)empty.summarize(new float[0]).average()));
        Histogram histogram = HistogramTest.createHistogram(70, 1, 2, 3, 4, 5, 6, 1);
        Assertions.assertEquals((int)3, (int)((int)histogram.summarize(new float[0]).average()));
        histogram.add(60);
        Assertions.assertEquals((int)10, (int)((int)histogram.summarize(new float[0]).average()));
    }

    @Test
    public void testHistogramSamples() {
        Histogram empty = HistogramTest.createHistogram(100, new int[0]);
        Assertions.assertEquals((long)0L, (long)empty.summarize(new float[0]).numSamples());
        Histogram histogram = HistogramTest.createHistogram(100, 4, 8, 2, 4, 1, 100, 150);
        Assertions.assertEquals((long)7L, (long)histogram.summarize(new float[0]).numSamples());
        histogram.add(60);
        Assertions.assertEquals((long)8L, (long)histogram.summarize(new float[0]).numSamples());
    }

    @Test
    public void testHistogramPercentiles() {
        Histogram histogram = HistogramTest.createHistogram(100, 1, 2, 3, 4, 5, 6, 80, 90);
        float[] percentiles = new float[]{0.5f, 0.9f, 0.99f, 1.0f};
        Histogram.Summary summary = histogram.summarize(percentiles);
        Assertions.assertEquals((long)8L, (long)summary.numSamples());
        Assertions.assertEquals((int)4, (int)((Histogram.PercentileSummary)summary.percentiles().get(0)).value());
        Assertions.assertEquals((int)80, (int)((Histogram.PercentileSummary)summary.percentiles().get(1)).value());
        Assertions.assertEquals((int)80, (int)((Histogram.PercentileSummary)summary.percentiles().get(2)).value());
        Assertions.assertEquals((int)90, (int)((Histogram.PercentileSummary)summary.percentiles().get(3)).value());
        histogram.add(30);
        histogram.add(30);
        histogram.add(30);
        summary = histogram.summarize(new float[]{0.5f});
        Assertions.assertEquals((long)11L, (long)summary.numSamples());
        Assertions.assertEquals((int)5, (int)((Histogram.PercentileSummary)summary.percentiles().get(0)).value());
        Histogram empty = HistogramTest.createHistogram(100, new int[0]);
        summary = empty.summarize(new float[]{0.5f});
        Assertions.assertEquals((int)0, (int)((Histogram.PercentileSummary)summary.percentiles().get(0)).value());
        histogram = HistogramTest.createHistogram(1000, new int[0]);
        histogram.add(100);
        histogram.add(200);
        summary = histogram.summarize(new float[]{0.0f, 0.5f, 1.0f});
        Assertions.assertEquals((int)0, (int)((Histogram.PercentileSummary)summary.percentiles().get(0)).value());
        Assertions.assertEquals((int)100, (int)((Histogram.PercentileSummary)summary.percentiles().get(1)).value());
        Assertions.assertEquals((int)200, (int)((Histogram.PercentileSummary)summary.percentiles().get(2)).value());
    }
}

