/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.trogdor.task.AgentWorkerStatusTracker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.ExternalCommandSpec;
import org.apache.kafka.trogdor.workload.ExternalCommandWorker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class ExternalCommandWorkerTest {
    @Test
    public void testProcessWithNormalExit() throws Exception {
        if (OperatingSystem.IS_WINDOWS) {
            return;
        }
        ExternalCommandWorker worker = new ExternalCommandWorkerBuilder("trueTask").command("true").build();
        KafkaFutureImpl doneFuture = new KafkaFutureImpl();
        worker.start(null, (WorkerStatusTracker)new AgentWorkerStatusTracker(), doneFuture);
        Assertions.assertEquals((Object)"", (Object)doneFuture.get());
        worker.stop(null);
    }

    @Test
    public void testProcessWithFailedExit() throws Exception {
        if (OperatingSystem.IS_WINDOWS) {
            return;
        }
        ExternalCommandWorker worker = new ExternalCommandWorkerBuilder("falseTask").command("false").build();
        KafkaFutureImpl doneFuture = new KafkaFutureImpl();
        worker.start(null, (WorkerStatusTracker)new AgentWorkerStatusTracker(), doneFuture);
        Assertions.assertEquals((Object)"exited with return code 1", (Object)doneFuture.get());
        worker.stop(null);
    }

    @Test
    public void testProcessNotFound() throws Exception {
        ExternalCommandWorker worker = new ExternalCommandWorkerBuilder("notFoundTask").command("/dev/null/non/existent/script/path").build();
        KafkaFutureImpl doneFuture = new KafkaFutureImpl();
        worker.start(null, (WorkerStatusTracker)new AgentWorkerStatusTracker(), doneFuture);
        String errorString = (String)doneFuture.get();
        Assertions.assertTrue((boolean)errorString.startsWith("Unable to start process"));
        worker.stop(null);
    }

    @Test
    public void testProcessStop() throws Exception {
        if (OperatingSystem.IS_WINDOWS) {
            return;
        }
        ExternalCommandWorker worker = new ExternalCommandWorkerBuilder("testStopTask").command("sleep", "3600000").build();
        KafkaFutureImpl doneFuture = new KafkaFutureImpl();
        worker.start(null, (WorkerStatusTracker)new AgentWorkerStatusTracker(), doneFuture);
        worker.stop(null);
        Assertions.assertTrue((boolean)((String)doneFuture.get()).startsWith("exited with return code "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessForceKillTimeout() throws Exception {
        if (OperatingSystem.IS_WINDOWS) {
            return;
        }
        File tempFile = null;
        try {
            tempFile = TestUtils.tempFile();
            try (OutputStream stream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                for (String line : new String[]{"echo hello world\n", "# Test that the initial message is sent correctly.\n", "read -r line\n", "[[ $line == '{\"id\":\"testForceKillTask\",\"workload\":{\"foo\":\"value1\",\"bar\":123}}' ]] || exit 0\n", "\n", "# Ignore SIGTERM signals.  This ensures that we test SIGKILL delivery.\n", "trap 'echo SIGTERM' SIGTERM\n", "\n", "# Update the process status.  This will also unblock the junit test.\n", "# It is important that we do this after we disabled SIGTERM, to ensure\n", "# that we are testing SIGKILL.\n", "echo '{\"status\": \"green\", \"log\": \"my log message.\"}'\n", "\n", "# Wait for the SIGKILL.\n", "while true; do sleep 0.01; done\n"}) {
                    stream.write(line.getBytes(StandardCharsets.UTF_8));
                }
            }
            CompletableFuture statusFuture = new CompletableFuture();
            WorkerStatusTracker statusTracker = status -> statusFuture.complete(status.textValue());
            ExternalCommandWorker worker = new ExternalCommandWorkerBuilder("testForceKillTask").shutdownGracePeriodMs(1).command("bash", tempFile.getAbsolutePath()).build();
            KafkaFutureImpl doneFuture = new KafkaFutureImpl();
            worker.start(null, statusTracker, doneFuture);
            Assertions.assertEquals((Object)"green", statusFuture.get());
            worker.stop(null);
            Assertions.assertTrue((boolean)((String)doneFuture.get()).startsWith("exited with return code "));
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile.toPath());
            }
        }
    }

    static class ExternalCommandWorkerBuilder {
        private final String id;
        private final ObjectNode workload;
        private int shutdownGracePeriodMs = 3000000;
        private String[] command = new String[0];

        ExternalCommandWorkerBuilder(String id) {
            this.id = id;
            this.workload = new ObjectNode(JsonNodeFactory.instance);
            this.workload.set("foo", (JsonNode)new TextNode("value1"));
            this.workload.set("bar", (JsonNode)new IntNode(123));
        }

        ExternalCommandWorker build() {
            ExternalCommandSpec spec = new ExternalCommandSpec(0L, 30000L, "node0", Arrays.asList(this.command), (JsonNode)this.workload, Optional.of(this.shutdownGracePeriodMs));
            return new ExternalCommandWorker(this.id, spec);
        }

        ExternalCommandWorkerBuilder command(String ... command) {
            this.command = command;
            return this;
        }

        ExternalCommandWorkerBuilder shutdownGracePeriodMs(int shutdownGracePeriodMs) {
            this.shutdownGracePeriodMs = shutdownGracePeriodMs;
            return this;
        }
    }
}

