/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.task;

import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.task.SampleTaskSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class TaskSpecTest {
    @Test
    public void testTaskSpecSerialization() throws Exception {
        Assertions.assertThrows(InvalidTypeIdException.class, () -> JsonUtil.JSON_SERDE.readValue("{\"startMs\":123,\"durationMs\":456,\"exitMs\":1000,\"error\":\"foo\"}", SampleTaskSpec.class), (String)"Missing type id should cause exception to be thrown");
        String inputJson = "{\"class\":\"org.apache.kafka.trogdor.task.SampleTaskSpec\",\"startMs\":123,\"durationMs\":456,\"nodeToExitMs\":{\"node01\":1000},\"error\":\"foo\"}";
        SampleTaskSpec spec = (SampleTaskSpec)((Object)JsonUtil.JSON_SERDE.readValue(inputJson, SampleTaskSpec.class));
        Assertions.assertEquals((long)123L, (long)spec.startMs());
        Assertions.assertEquals((long)456L, (long)spec.durationMs());
        Assertions.assertEquals((Long)1000L, (Long)spec.nodeToExitMs().get("node01"));
        Assertions.assertEquals((Object)"foo", (Object)spec.error());
        String outputJson = JsonUtil.toJsonString((Object)((Object)spec));
        Assertions.assertEquals((Object)inputJson, (Object)outputJson);
    }
}

