/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.task.SampleTaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;

public class SampleTaskWorker
implements TaskWorker {
    private final SampleTaskSpec spec;
    private final ScheduledExecutorService executor;
    private Future<Void> future;
    private WorkerStatusTracker status;

    SampleTaskWorker(SampleTaskSpec spec) {
        this.spec = spec;
        this.executor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"SampleTaskWorker", (boolean)false));
        this.future = null;
    }

    public synchronized void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) {
        if (this.future != null) {
            return;
        }
        this.status = status;
        this.status.update((JsonNode)new TextNode("active"));
        Long exitMs = this.spec.nodeToExitMs().get(platform.curNode().name());
        if (exitMs == null) {
            exitMs = Long.MAX_VALUE;
        }
        this.future = platform.scheduler().schedule(this.executor, () -> {
            haltFuture.complete((Object)this.spec.error());
            return null;
        }, exitMs.longValue());
    }

    public void stop(Platform platform) throws Exception {
        this.future.cancel(false);
        this.executor.shutdown();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.status.update((JsonNode)new TextNode("halted"));
    }
}

