/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.rest;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.trogdor.rest.RestExceptionMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestExceptionMapperTest {
    @Test
    public void testToResponseNotFound() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        Response resp = mapper.toResponse((Throwable)new NotFoundException());
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void testToResponseInvalidTypeIdException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        JsonParser parser = null;
        JavaType type = null;
        Response resp = mapper.toResponse((Throwable)InvalidTypeIdException.from(parser, (String)"dummy msg", type, (String)"dummy typeId"));
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.NOT_IMPLEMENTED.getStatusCode());
    }

    @Test
    public void testToResponseJsonMappingException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        JsonParser parser = null;
        Response resp = mapper.toResponse((Throwable)JsonMappingException.from(parser, (String)"dummy msg"));
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void testToResponseClassNotFoundException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        Response resp = mapper.toResponse((Throwable)new ClassNotFoundException());
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.NOT_IMPLEMENTED.getStatusCode());
    }

    @Test
    public void testToResponseSerializationException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        Response resp = mapper.toResponse((Throwable)new SerializationException());
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void testToResponseInvalidRequestException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        Response resp = mapper.toResponse((Throwable)new InvalidRequestException("invalid request"));
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void testToResponseUnknownException() {
        RestExceptionMapper mapper = new RestExceptionMapper();
        Response resp = mapper.toResponse((Throwable)new Exception("Unknown exception"));
        Assertions.assertEquals((int)resp.getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    @Test
    public void testToExceptionNotFoundException() {
        Assertions.assertThrows(NotFoundException.class, () -> RestExceptionMapper.toException((int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Not Found"));
    }

    @Test
    public void testToExceptionClassNotFoundException() {
        Assertions.assertThrows(ClassNotFoundException.class, () -> RestExceptionMapper.toException((int)Response.Status.NOT_IMPLEMENTED.getStatusCode(), (String)"Not Implemented"));
    }

    @Test
    public void testToExceptionSerializationException() {
        Assertions.assertThrows(InvalidRequestException.class, () -> RestExceptionMapper.toException((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Bad Request"));
    }

    @Test
    public void testToExceptionRuntimeException() {
        Assertions.assertThrows(RuntimeException.class, () -> RestExceptionMapper.toException((int)-1, (String)"Unknown status code"));
    }
}

