/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.kafka.trogdor.common.StringFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class StringFormatterTest {
    @Test
    public void testDateString() {
        Assertions.assertEquals((Object)"2019-01-08T20:59:29.85Z", (Object)StringFormatter.dateString((long)1546981169850L, (ZoneOffset)ZoneOffset.UTC));
    }

    @Test
    public void testDurationString() {
        Assertions.assertEquals((Object)"1m", (Object)StringFormatter.durationString((long)60000L));
        Assertions.assertEquals((Object)"1m1s", (Object)StringFormatter.durationString((long)61000L));
        Assertions.assertEquals((Object)"1m1s", (Object)StringFormatter.durationString((long)61200L));
        Assertions.assertEquals((Object)"5s", (Object)StringFormatter.durationString((long)5000L));
        Assertions.assertEquals((Object)"2h", (Object)StringFormatter.durationString((long)0x6DDD00L));
        Assertions.assertEquals((Object)"2h1s", (Object)StringFormatter.durationString((long)7201000L));
        Assertions.assertEquals((Object)"2h5m3s", (Object)StringFormatter.durationString((long)7503000L));
    }

    @Test
    public void testPrettyPrintGrid() {
        Assertions.assertEquals((Object)String.format("ANIMAL  NUMBER INDEX %nlion    1      12345 %nmanatee 50     1     %n", new Object[0]), (Object)StringFormatter.prettyPrintGrid(Arrays.asList(Arrays.asList("ANIMAL", "NUMBER", "INDEX"), Arrays.asList("lion", "1", "12345"), Arrays.asList("manatee", "50", "1"))));
    }
}

