/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.kafka.trogdor.common.StringExpander;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class StringExpanderTest {
    @Test
    public void testNoExpansionNeeded() {
        Assertions.assertEquals(Collections.singleton("foo"), (Object)StringExpander.expand((String)"foo"));
        Assertions.assertEquals(Collections.singleton("bar"), (Object)StringExpander.expand((String)"bar"));
        Assertions.assertEquals(Collections.singleton(""), (Object)StringExpander.expand((String)""));
    }

    @Test
    public void testExpansions() {
        HashSet<String> expected1 = new HashSet<String>(Arrays.asList("foo1", "foo2", "foo3"));
        Assertions.assertEquals(expected1, (Object)StringExpander.expand((String)"foo[1-3]"));
        HashSet<String> expected2 = new HashSet<String>(Arrays.asList("foo bar baz 0"));
        Assertions.assertEquals(expected2, (Object)StringExpander.expand((String)"foo bar baz [0-0]"));
        HashSet<String> expected3 = new HashSet<String>(Arrays.asList("[[ wow50 ]]", "[[ wow51 ]]", "[[ wow52 ]]"));
        Assertions.assertEquals(expected3, (Object)StringExpander.expand((String)"[[ wow[50-52] ]]"));
        HashSet<String> expected4 = new HashSet<String>(Arrays.asList("foo1bar", "foo2bar", "foo3bar"));
        Assertions.assertEquals(expected4, (Object)StringExpander.expand((String)"foo[1-3]bar"));
        HashSet<String> expected5 = new HashSet<String>(Arrays.asList("start[1-3]middle1epilogue", "start[1-3]middle2epilogue", "start[1-3]middle3epilogue"));
        Assertions.assertEquals(expected5, (Object)StringExpander.expand((String)"start[1-3]middle[1-3]epilogue"));
    }
}

