/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.fault.FilesUnreadableFaultSpec;
import org.apache.kafka.trogdor.fault.Kibosh;
import org.apache.kafka.trogdor.fault.NetworkPartitionFaultSpec;
import org.apache.kafka.trogdor.fault.ProcessStopFaultSpec;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.apache.kafka.trogdor.rest.WorkerDone;
import org.apache.kafka.trogdor.rest.WorkerRunning;
import org.apache.kafka.trogdor.rest.WorkerStopping;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.ProduceBenchSpec;
import org.apache.kafka.trogdor.workload.RoundTripWorkloadSpec;
import org.apache.kafka.trogdor.workload.TopicsSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonSerializationTest {
    @Test
    public void testDeserializationDoesNotProduceNulls() throws Exception {
        this.verify(new FilesUnreadableFaultSpec(0L, 0L, null, null, null, 0));
        this.verify(new Kibosh.KiboshControlFile(null));
        this.verify(new NetworkPartitionFaultSpec(0L, 0L, null));
        this.verify(new ProcessStopFaultSpec(0L, 0L, null, null));
        this.verify(new AgentStatusResponse(0L, null));
        this.verify(new TasksResponse(null));
        this.verify(new WorkerDone(null, null, 0L, 0L, null, null));
        this.verify(new WorkerRunning(null, null, 0L, null));
        this.verify(new WorkerStopping(null, null, 0L, null));
        this.verify(new ProduceBenchSpec(0L, 0L, null, null, 0, 0L, null, null, Optional.empty(), null, null, null, null, null, false, false));
        this.verify(new RoundTripWorkloadSpec(0L, 0L, null, null, null, null, null, null, 0, null, null, 0L));
        this.verify(new TopicsSpec());
        this.verify(new PartitionsSpec(0, 0, null, null));
        HashMap<Integer, List<Integer>> partitionAssignments = new HashMap<Integer, List<Integer>>();
        partitionAssignments.put(0, Arrays.asList(1, 2, 3));
        partitionAssignments.put(1, Arrays.asList(1, 2, 3));
        this.verify(new PartitionsSpec(0, 0, partitionAssignments, null));
        this.verify(new PartitionsSpec(0, 0, null, null));
    }

    private <T> void verify(T val1) throws Exception {
        byte[] bytes = JsonUtil.JSON_SERDE.writeValueAsBytes(val1);
        Class<?> clazz = val1.getClass();
        Object val2 = JsonUtil.JSON_SERDE.readValue(bytes, clazz);
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            boolean wasAccessible = field.canAccess(val2);
            field.setAccessible(true);
            Assertions.assertNotNull((Object)field.get(val2), (String)("Field " + String.valueOf(field) + " was null."));
            field.setAccessible(wasAccessible);
        }
    }
}

