/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.trogdor.basic.BasicPlatform;
import org.apache.kafka.trogdor.common.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapturingCommandRunner
implements BasicPlatform.CommandRunner {
    private static final Logger log = LoggerFactory.getLogger(CapturingCommandRunner.class);
    private final Map<String, List<String>> commands = new HashMap<String, List<String>>();

    private synchronized List<String> getOrCreate(String nodeName) {
        List<String> lines = this.commands.get(nodeName);
        if (lines != null) {
            return lines;
        }
        lines = new LinkedList<String>();
        this.commands.put(nodeName, lines);
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Node curNode, String[] command) {
        String line = String.join((CharSequence)" ", command);
        CapturingCommandRunner capturingCommandRunner = this;
        synchronized (capturingCommandRunner) {
            this.getOrCreate(curNode.name()).add(line);
        }
        log.debug("RAN {}: {}", (Object)curNode, (Object)String.join((CharSequence)" ", command));
        return "";
    }

    public synchronized List<String> lines(String nodeName) {
        return new ArrayList<String>(this.getOrCreate(nodeName));
    }
}

