/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload.partitioner;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.trogdor.workload.partitioner.GaussianPartitionerConfig;
import org.apache.kafka.trogdor.workload.partitioner.GaussianPartitionerUtils;

public class GaussianPartitioner
implements Partitioner {
    private final Random random = new Random();
    private int mean;
    private int std;

    public void configure(Map<String, ?> configs) {
        GaussianPartitionerConfig config = new GaussianPartitionerConfig(configs);
        this.mean = config.getInt("confluent.gaussian.partitioner.mean");
        this.std = config.getInt("confluent.gaussian.partitioner.std");
    }

    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List partitions = cluster.partitionsForTopic(topic);
        return GaussianPartitionerUtils.nextPartition(partitions.size(), this.random, this.std, this.mean);
    }

    public void close() {
    }
}

