/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ConsumerGroupsWorker;
import org.apache.kafka.trogdor.workload.TopicsSpec;

public class ConsumerGroupsSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final Map<String, String> commonClientConf;
    private final Map<String, String> adminClientConf;
    private final int targetOperationsPerSec;
    private final List<ConsumerGroupOperation> operations;
    private final TopicsSpec activeTopics;
    private final boolean initializeGroupOffsets;
    private final String groupPrefix;
    private final int noOfGroups;

    @JsonCreator
    public ConsumerGroupsSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="targetOperationsPerSec") int targetOperationsPerSec, @JsonProperty(value="operations") List<ConsumerGroupOperation> operations, @JsonProperty(value="activeTopics") TopicsSpec activeTopics, @JsonProperty(value="initializeGroupOffsets") Boolean initializeGroupOffsets, @JsonProperty(value="groupPrefix") String groupPrefix, @JsonProperty(value="noOfGroups") int noOfGroups) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.commonClientConf = commonClientConf == null ? Collections.emptyMap() : commonClientConf;
        this.adminClientConf = adminClientConf == null ? Collections.emptyMap() : adminClientConf;
        this.targetOperationsPerSec = targetOperationsPerSec;
        this.operations = operations;
        this.activeTopics = activeTopics;
        this.initializeGroupOffsets = initializeGroupOffsets == null || initializeGroupOffsets != false;
        this.groupPrefix = groupPrefix == null ? "" : groupPrefix;
        this.noOfGroups = noOfGroups;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public int targetOperationsPerSec() {
        return this.targetOperationsPerSec;
    }

    @JsonProperty
    public List<ConsumerGroupOperation> operations() {
        return this.operations;
    }

    @JsonProperty
    public TopicsSpec activeTopics() {
        return this.activeTopics;
    }

    @JsonProperty
    public boolean initializeGroupOffsets() {
        return this.initializeGroupOffsets;
    }

    @JsonProperty
    public String groupPrefix() {
        return this.groupPrefix;
    }

    @JsonProperty
    public int noOfGroups() {
        return this.noOfGroups;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ConsumerGroupsWorker(id, this);
    }

    static enum ConsumerGroupOperation {
        LIST_GROUPS,
        DESCRIBE_GROUPS,
        LIST_OFFSETS,
        ALTER_OFFSETS;

    }
}

