/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import org.apache.kafka.trogdor.fault.CloudAZNetworkFaultWorker;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAZNetworkFaultSpec
extends TaskSpec {
    private static final Logger log = LoggerFactory.getLogger(CloudAZNetworkFaultSpec.class);
    private final String azName;

    @JsonCreator
    protected CloudAZNetworkFaultSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="azName") String azName) {
        super(startMs, durationMs);
        this.azName = azName;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> {
            String agentNode = topology.nodes().keySet().stream().filter(node -> node.contains("agent")).findAny().get();
            log.info("Nodes in the topology from Nodes {}, Node selected: {}", topology.nodes().keySet(), (Object)agentNode);
            return Collections.singleton(agentNode);
        };
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new CloudAZNetworkFaultWorker(id, this.getAzName());
    }

    public String getAzName() {
        return this.azName;
    }
}

