/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.trogdor.workload.RecordBatchVerifier;
import org.apache.kafka.trogdor.workload.SequentialOffsetsRecordBatchVerifier;
import org.apache.kafka.trogdor.workload.SequentialOffsetsVerificationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordBatchVerifierTest {
    @Test
    public void testSequentialOffsetRecordBatchVerifierNoFailure() {
        SequentialOffsetsRecordBatchVerifier recordBatchVerifier = new SequentialOffsetsRecordBatchVerifier();
        recordBatchVerifier.verifyRecords(ConsumerRecords.empty());
        final TopicPartition topicPartition0 = new TopicPartition("foo", 0);
        final TopicPartition topicPartition1 = new TopicPartition("foo", 1);
        HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> recordsMap = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(){
            {
                this.put(topicPartition0, Arrays.asList(new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 0L, null, null), new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 1L, null, null)));
                this.put(topicPartition1, Arrays.asList(new ConsumerRecord(topicPartition1.topic(), topicPartition1.partition(), 50L, null, null), new ConsumerRecord(topicPartition1.topic(), topicPartition1.partition(), 51L, null, null)));
            }
        };
        ConsumerRecords consumerRecords = new ConsumerRecords((Map)recordsMap);
        recordBatchVerifier.verifyRecords(consumerRecords);
    }

    @Test
    public void testSequentialOffsetRecordBatchVerifierFailure() {
        SequentialOffsetsRecordBatchVerifier recordBatchVerifier = new SequentialOffsetsRecordBatchVerifier();
        recordBatchVerifier.verifyRecords(ConsumerRecords.empty());
        final TopicPartition topicPartition0 = new TopicPartition("foo", 0);
        HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> recordsMap = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(){
            {
                this.put(topicPartition0, Arrays.asList(new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 0L, null, null), new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 2L, null, null)));
            }
        };
        ConsumerRecords consumerRecords = new ConsumerRecords((Map)recordsMap);
        Assertions.assertThrows(SequentialOffsetsVerificationException.class, () -> RecordBatchVerifierTest.lambda$testSequentialOffsetRecordBatchVerifierFailure$0((RecordBatchVerifier)recordBatchVerifier, consumerRecords));
    }

    @Test
    public void testSequentialOffsetRecordBatchVerifierClearsPreviousOffsetsOnPartitionAssignment() {
        SequentialOffsetsRecordBatchVerifier recordBatchVerifier = new SequentialOffsetsRecordBatchVerifier();
        final TopicPartition topicPartition0 = new TopicPartition("foo", 0);
        HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> recordsMap = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(){
            {
                this.put(topicPartition0, Collections.singletonList(new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 0L, null, null)));
            }
        };
        recordBatchVerifier.verifyRecords(new ConsumerRecords((Map)recordsMap));
        recordBatchVerifier.onPartitionsAssigned(null);
        recordsMap = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(){
            {
                this.put(topicPartition0, Collections.singletonList(new ConsumerRecord(topicPartition0.topic(), topicPartition0.partition(), 2L, null, null)));
            }
        };
        recordBatchVerifier.verifyRecords(new ConsumerRecords((Map)recordsMap));
    }

    private static /* synthetic */ void lambda$testSequentialOffsetRecordBatchVerifierFailure$0(RecordBatchVerifier recordBatchVerifier, ConsumerRecords consumerRecords) throws Throwable {
        recordBatchVerifier.verifyRecords(consumerRecords);
    }
}

