/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.trogdor.workload.ConstantPayloadGenerator;
import org.apache.kafka.trogdor.workload.NullPayloadGenerator;
import org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.kafka.trogdor.workload.PayloadIterator;
import org.apache.kafka.trogdor.workload.RandomComponent;
import org.apache.kafka.trogdor.workload.RandomComponentPayloadGenerator;
import org.apache.kafka.trogdor.workload.SequentialPayloadGenerator;
import org.apache.kafka.trogdor.workload.UniformRandomPayloadGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class PayloadGeneratorTest {
    @Test
    public void testConstantPayloadGenerator() {
        byte[] alphabet = new byte[26];
        for (int i = 0; i < alphabet.length; ++i) {
            alphabet[i] = (byte)(97 + i);
        }
        byte[] expectedSuperset = new byte[512];
        for (int i = 0; i < expectedSuperset.length; ++i) {
            expectedSuperset[i] = (byte)(97 + i % 26);
        }
        for (int i : new int[]{1, 5, 10, 100, 511, 512}) {
            ConstantPayloadGenerator generator = new ConstantPayloadGenerator(i, alphabet);
            PayloadGeneratorTest.assertArrayContains(expectedSuperset, generator.generate(0L));
            PayloadGeneratorTest.assertArrayContains(expectedSuperset, generator.generate(10L));
            PayloadGeneratorTest.assertArrayContains(expectedSuperset, generator.generate(100L));
        }
    }

    private static void assertArrayContains(byte[] expectedSuperset, byte[] actual) {
        byte[] expected = new byte[actual.length];
        System.arraycopy(expectedSuperset, 0, expected, 0, expected.length);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testSequentialPayloadGenerator() {
        SequentialPayloadGenerator g4 = new SequentialPayloadGenerator(4, 1L);
        PayloadGeneratorTest.assertLittleEndianArrayEquals(1L, g4.generate(0L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(2L, g4.generate(1L));
        SequentialPayloadGenerator g8 = new SequentialPayloadGenerator(8, 0L);
        PayloadGeneratorTest.assertLittleEndianArrayEquals(0L, g8.generate(0L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(1L, g8.generate(1L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(123123123123L, g8.generate(123123123123L));
        SequentialPayloadGenerator g2 = new SequentialPayloadGenerator(2, 0L);
        PayloadGeneratorTest.assertLittleEndianArrayEquals(0L, g2.generate(0L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(1L, g2.generate(1L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(1L, g2.generate(1L));
        PayloadGeneratorTest.assertLittleEndianArrayEquals(1L, g2.generate(131073L));
    }

    private static void assertLittleEndianArrayEquals(long expected, byte[] actual) {
        byte[] longActual = new byte[8];
        System.arraycopy(actual, 0, longActual, 0, Math.min(actual.length, longActual.length));
        ByteBuffer buf = ByteBuffer.wrap(longActual).order(ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((long)expected, (long)buf.getLong());
    }

    @Test
    public void testUniformRandomPayloadGenerator() {
        PayloadIterator iter = new PayloadIterator((PayloadGenerator)new UniformRandomPayloadGenerator(1234, 456L, 0));
        byte[] prev = iter.next();
        int uniques = 0;
        while (uniques < 1000) {
            byte[] cur = iter.next();
            Assertions.assertEquals((int)prev.length, (int)cur.length);
            if (Arrays.equals(prev, cur)) continue;
            ++uniques;
        }
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new UniformRandomPayloadGenerator(1234, 456L, 0));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new UniformRandomPayloadGenerator(1, 0L, 0));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new UniformRandomPayloadGenerator(10, 6L, 5));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new UniformRandomPayloadGenerator(512, 123L, 100));
    }

    private static void testReproducible(PayloadGenerator generator) {
        byte[] val = generator.generate(123L);
        generator.generate(456L);
        byte[] val2 = generator.generate(123L);
        if (val == null) {
            Assertions.assertNull((Object)val2);
        } else {
            Assertions.assertArrayEquals((byte[])val, (byte[])val2);
        }
    }

    @Test
    public void testUniformRandomPayloadGeneratorPaddingBytes() {
        UniformRandomPayloadGenerator generator = new UniformRandomPayloadGenerator(1000, 456L, 100);
        byte[] val1 = generator.generate(0L);
        byte[] val1End = new byte[100];
        System.arraycopy(val1, 900, val1End, 0, 100);
        byte[] val2 = generator.generate(100L);
        byte[] val2End = new byte[100];
        System.arraycopy(val2, 900, val2End, 0, 100);
        byte[] val3 = generator.generate(200L);
        byte[] val3End = new byte[100];
        System.arraycopy(val3, 900, val3End, 0, 100);
        Assertions.assertArrayEquals((byte[])val1End, (byte[])val2End);
        Assertions.assertArrayEquals((byte[])val1End, (byte[])val3End);
    }

    @Test
    public void testRandomComponentPayloadGenerator() {
        NullPayloadGenerator nullGenerator = new NullPayloadGenerator();
        RandomComponent nullConfig = new RandomComponent(50, (PayloadGenerator)nullGenerator);
        UniformRandomPayloadGenerator uniformGenerator = new UniformRandomPayloadGenerator(5, 123L, 0);
        RandomComponent uniformConfig = new RandomComponent(50, (PayloadGenerator)uniformGenerator);
        SequentialPayloadGenerator sequentialGenerator = new SequentialPayloadGenerator(4, 10L);
        RandomComponent sequentialConfig = new RandomComponent(75, (PayloadGenerator)sequentialGenerator);
        ConstantPayloadGenerator constantGenerator = new ConstantPayloadGenerator(4, new byte[0]);
        RandomComponent constantConfig = new RandomComponent(25, (PayloadGenerator)constantGenerator);
        ArrayList<RandomComponent> components1 = new ArrayList<RandomComponent>(Arrays.asList(nullConfig, uniformConfig));
        ArrayList<RandomComponent> components2 = new ArrayList<RandomComponent>(Arrays.asList(sequentialConfig, constantConfig));
        byte[] expected = new byte[4];
        PayloadIterator iter = new PayloadIterator((PayloadGenerator)new RandomComponentPayloadGenerator(4L, components1));
        int notNull = 0;
        int isNull = 0;
        while (notNull < 1000 || isNull < 1000) {
            byte[] cur = iter.next();
            if (cur == null) {
                ++isNull;
                continue;
            }
            ++notNull;
        }
        iter = new PayloadIterator((PayloadGenerator)new RandomComponentPayloadGenerator(123L, components2));
        int isZeroBytes = 0;
        int isNotZeroBytes = 0;
        while (isZeroBytes < 500 || isNotZeroBytes < 1500) {
            byte[] cur = iter.next();
            if (Arrays.equals(expected, cur)) {
                ++isZeroBytes;
                continue;
            }
            ++isNotZeroBytes;
        }
        RandomComponent uniformConfig2 = new RandomComponent(25, (PayloadGenerator)uniformGenerator);
        RandomComponent sequentialConfig2 = new RandomComponent(25, (PayloadGenerator)sequentialGenerator);
        RandomComponent nullConfig2 = new RandomComponent(25, (PayloadGenerator)nullGenerator);
        ArrayList<RandomComponent> components3 = new ArrayList<RandomComponent>(Arrays.asList(sequentialConfig2, uniformConfig2, nullConfig));
        ArrayList<RandomComponent> components4 = new ArrayList<RandomComponent>(Arrays.asList(uniformConfig2, sequentialConfig2, constantConfig, nullConfig2));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new RandomComponentPayloadGenerator(4L, components1));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new RandomComponentPayloadGenerator(123L, components2));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new RandomComponentPayloadGenerator(50L, components3));
        PayloadGeneratorTest.testReproducible((PayloadGenerator)new RandomComponentPayloadGenerator(0L, components4));
    }

    @Test
    public void testRandomComponentPayloadGeneratorErrors() {
        NullPayloadGenerator nullGenerator = new NullPayloadGenerator();
        RandomComponent nullConfig = new RandomComponent(25, (PayloadGenerator)nullGenerator);
        UniformRandomPayloadGenerator uniformGenerator = new UniformRandomPayloadGenerator(5, 123L, 0);
        RandomComponent uniformConfig = new RandomComponent(25, (PayloadGenerator)uniformGenerator);
        ConstantPayloadGenerator constantGenerator = new ConstantPayloadGenerator(4, new byte[0]);
        RandomComponent constantConfig = new RandomComponent(-25, (PayloadGenerator)constantGenerator);
        ArrayList<RandomComponent> components1 = new ArrayList<RandomComponent>(Arrays.asList(nullConfig, uniformConfig));
        ArrayList<RandomComponent> components2 = new ArrayList<RandomComponent>(Arrays.asList(nullConfig, constantConfig, uniformConfig, nullConfig, uniformConfig, uniformConfig));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PayloadIterator((PayloadGenerator)new RandomComponentPayloadGenerator(1L, new ArrayList())));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PayloadIterator((PayloadGenerator)new RandomComponentPayloadGenerator(13L, components2)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PayloadIterator((PayloadGenerator)new RandomComponentPayloadGenerator(123L, components1)));
    }

    @Test
    public void testPayloadIterator() {
        int expectedSize = 50;
        PayloadIterator iter = new PayloadIterator((PayloadGenerator)new ConstantPayloadGenerator(50, new byte[0]));
        byte[] expected = new byte[50];
        Assertions.assertEquals((long)0L, (long)iter.position());
        Assertions.assertArrayEquals((byte[])expected, (byte[])iter.next());
        Assertions.assertEquals((long)1L, (long)iter.position());
        Assertions.assertArrayEquals((byte[])expected, (byte[])iter.next());
        Assertions.assertArrayEquals((byte[])expected, (byte[])iter.next());
        Assertions.assertEquals((long)3L, (long)iter.position());
        iter.seek(0L);
        Assertions.assertEquals((long)0L, (long)iter.position());
    }

    @Test
    public void testNullPayloadGenerator() {
        NullPayloadGenerator generator = new NullPayloadGenerator();
        Assertions.assertNull((Object)generator.generate(0L));
        Assertions.assertNull((Object)generator.generate(1L));
        Assertions.assertNull((Object)generator.generate(100L));
    }
}

