/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload.partitioner;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.trogdor.workload.partitioner.GaussianPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class GaussianPartitionerTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(12, "localhost", 101)};
    private static final String TOPIC = "test";
    private static final List<PartitionInfo> PARTITIONS = Arrays.asList(new PartitionInfo("test", 1, null, NODES, NODES), new PartitionInfo("test", 2, NODES[1], NODES, NODES), new PartitionInfo("test", 3, NODES[1], NODES, NODES), new PartitionInfo("test", 4, NODES[0], NODES, NODES), new PartitionInfo("test", 0, NODES[0], NODES, NODES));
    private static final Cluster CLUSTER = new Cluster("clusterId", Arrays.asList(NODES), PARTITIONS, Collections.emptySet(), Collections.emptySet());

    @Test
    public void testPartitioner() {
        for (int mean = 0; mean < PARTITIONS.size(); ++mean) {
            this.testPartitionerWithMean(mean, 1);
        }
    }

    public void testPartitionerWithMean(int mean, int std) {
        HashMap<String, Integer> configs = new HashMap<String, Integer>();
        configs.put("confluent.gaussian.partitioner.mean", mean);
        configs.put("confluent.gaussian.partitioner.std", std);
        GaussianPartitioner partitioner = new GaussianPartitioner();
        partitioner.configure(configs);
        int[] distributions = new int[PARTITIONS.size()];
        for (int i = 0; i < 10000; ++i) {
            int partition = partitioner.partition(TOPIC, null, null, null, null, CLUSTER);
            Assertions.assertTrue((partition >= 0 ? 1 : 0) != 0);
            Assertions.assertTrue((partition < PARTITIONS.size() ? 1 : 0) != 0);
            int n = partition;
            distributions[n] = distributions[n] + 1;
        }
        Assertions.assertTrue((distributions[this.index(mean)] > distributions[this.index(mean - 1)] ? 1 : 0) != 0);
        Assertions.assertTrue((distributions[this.index(mean - 1)] > distributions[this.index(mean - 2)] ? 1 : 0) != 0);
        Assertions.assertTrue((distributions[this.index(mean)] > distributions[this.index(mean + 1)] ? 1 : 0) != 0);
        Assertions.assertTrue((distributions[this.index(mean + 1)] > distributions[this.index(mean + 2)] ? 1 : 0) != 0);
    }

    private int index(int pos) {
        return (pos + PARTITIONS.size()) % PARTITIONS.size();
    }
}

