/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.TimeIntervalTransactionsGenerator;
import org.apache.kafka.trogdor.workload.TransactionGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeIntervalTransactionsGeneratorTest {
    @Test
    public void testCommitsTransactionAfterIntervalPasses() {
        MockTime time = new MockTime();
        TimeIntervalTransactionsGenerator generator = new TimeIntervalTransactionsGenerator(100, (Time)time);
        Assertions.assertEquals((int)100, (int)generator.transactionIntervalMs());
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.BEGIN_TRANSACTION, (Object)generator.nextAction());
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.NO_OP, (Object)generator.nextAction());
        time.sleep(50L);
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.NO_OP, (Object)generator.nextAction());
        time.sleep(49L);
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.NO_OP, (Object)generator.nextAction());
        time.sleep(1L);
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.COMMIT_TRANSACTION, (Object)generator.nextAction());
        Assertions.assertEquals((Object)TransactionGenerator.TransactionAction.BEGIN_TRANSACTION, (Object)generator.nextAction());
    }
}

