/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.Throttle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrottleTest {
    @Test
    public void testThrottle() throws Exception {
        MockTime time = new MockTime(0L, 0L, 0L);
        ThrottleMock throttle = new ThrottleMock(time, 3);
        Assertions.assertFalse((boolean)throttle.increment());
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Assertions.assertFalse((boolean)throttle.increment());
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Assertions.assertFalse((boolean)throttle.increment());
        Assertions.assertEquals((long)0L, (long)time.milliseconds());
        Assertions.assertTrue((boolean)throttle.increment());
        Assertions.assertEquals((long)100L, (long)time.milliseconds());
        time.sleep(50L);
        Assertions.assertFalse((boolean)throttle.increment());
        Assertions.assertEquals((long)150L, (long)time.milliseconds());
        Assertions.assertFalse((boolean)throttle.increment());
        Assertions.assertEquals((long)150L, (long)time.milliseconds());
        Assertions.assertTrue((boolean)throttle.increment());
        Assertions.assertEquals((long)200L, (long)time.milliseconds());
    }

    private static class ThrottleMock
    extends Throttle {
        final MockTime time;

        ThrottleMock(MockTime time, int maxPerSec) {
            super(maxPerSec, 100);
            this.time = time;
        }

        protected Time time() {
            return this.time;
        }

        protected synchronized void delay(long amount) throws InterruptedException {
            this.time.sleep(amount);
        }
    }
}

