/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.util.concurrent.TimeUnit;
import kafka.tier.compatibility.Logger;
import org.junit.AssumptionViolatedException;
import org.junit.rules.Stopwatch;
import org.junit.runner.Description;

class TimeLoggingStopwatch
extends Stopwatch {
    TimeLoggingStopwatch() {
    }

    protected void succeeded(long nanos, Description description) {
        new Logger().info(description.getMethodName() + " succeeded in " + TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) + "s");
    }

    protected void failed(long nanos, Throwable e, Description description) {
        new Logger().error(description.getMethodName() + " failed in " + TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) + String.format("s. Cause: '%s'", e.getMessage()));
    }

    protected void skipped(long nanos, AssumptionViolatedException e, Description description) {
        new Logger().error(description.getMethodName() + " skipped in " + TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) + String.format("s. Cause: '%s'", e));
    }
}

