/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.util.HashSet;
import java.util.Properties;
import kafka.tier.compatibility.CustomTextListener;
import kafka.tier.compatibility.Logger;
import kafka.tier.compatibility.RemoteTierObjectStoreTest;
import kafka.tier.compatibility.TierTestConfig;
import kafka.tier.compatibility.TierTestUtils;
import kafka.tier.compatibility.TieringFunctionalityTest;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.jmh.tier.TierFetcherBenchmark;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class TierObjectStoreCompatibilityChecker {
    public static final String TEST_OBJECT_STORE = "test-object-store";
    public static final String TEST_TIERED_STORAGE_CORRECTNESS = "test-tiered-storage-correctness";
    public static final String TEST_TIERED_STORAGE_FETCH = "test-tiered-storage-fetch";
    public static final String WAIT_TIERING_COMPLETION = "wait-tiering-completion";
    public static final String VALIDATE_CONFIGURATION = "validate-configuration";
    public static final String SELECTED_COMMAND = "selected_command";

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierObjectStoreCompatibilityChecker.class.getName());
        String helpMessage = "This CLI tool provides a test suite and utilities to assess the compatibility of an object store with Tiered Storage. Currently, this test suite only evaluates object stores that implement the S3 API. The tool requires a Java properties file to be passed as input via the --config-file CLI option.\n\n" + TierTestConfig.configDocString();
        parser.usage(helpMessage);
        parser.addArgument(new String[]{"--config-file"}).action((ArgumentAction)Arguments.store()).dest("configFile").help("Accepts a valid .properties file, the contents of which are parsed to setup the configuration for the tests. The supported properties are described above.");
        Subparsers subparsers = parser.addSubparsers().title("Valid sub-commands:").dest(SELECTED_COMMAND);
        Subparser objectStoreCorrectness = subparsers.addParser(TEST_OBJECT_STORE).help("Runs the object store correctness test suite.");
        Subparser tieredStorageCorrectness = subparsers.addParser(TEST_TIERED_STORAGE_CORRECTNESS).help("Runs the tiering functionality correctness test suite.");
        Subparser tierFetcherBenchmark = subparsers.addParser(TEST_TIERED_STORAGE_FETCH).help("Runs the benchmark that exercises tiered storage fetch path.");
        tierFetcherBenchmark.addArgument(new String[]{"--output_file"}).action((ArgumentAction)Arguments.store()).dest("tierFetcherBenchmarkOutputFile").help("The file that would contain the output of the tier fetcher becnhmark results.");
        Subparser waitTieringCompletion = subparsers.addParser(WAIT_TIERING_COMPLETION).help("Waits until metrics indicate that tiering has completed for the provided topic.");
        waitTieringCompletion.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).dest("topic").help("The topic to be waited for tiering completion.");
        Subparser validateConfiguration = subparsers.addParser(VALIDATE_CONFIGURATION).help("Validates the provided configuration file exiting with a non-zero status when invalid. When successful, prints the validated configuration with default values included to stdout in a newline separated 'key=value' format.");
        Result result = null;
        try {
            Namespace res = parser.parseArgs(args);
            Properties props = Utils.loadProps((String)res.getString("configFile"));
            TierTestConfig config = new TierTestConfig(props, true);
            Class[] classes = TierObjectStoreCompatibilityChecker.getAndInitTestClasses(config, res.getString(SELECTED_COMMAND), res.getString("topic"), res.getString("tierFetcherBenchmarkOutputFile"));
            if (classes.length > 0) {
                JUnitCore junit = new JUnitCore();
                junit.addListener((RunListener)new CustomTextListener(System.err));
                result = junit.run(classes);
            }
        }
        catch (HelpScreenException res) {
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            throw e;
        }
        finally {
            if (result != null && !result.wasSuccessful()) {
                Exit.exit((int)1);
            }
        }
    }

    private static void waitTieringCompletion(TierTestConfig config, String topic) throws Exception {
        boolean debug = config.getBoolean(TierTestConfig.DebugProp());
        String jmxAuth = config.getString(TierTestConfig.JmxAuthProp());
        int jmxPort = config.getInt(TierTestConfig.JmxPortProp());
        boolean jmxSsl = config.getBoolean(TierTestConfig.JmxSslProp());
        int numPartitions = config.getInt(TierTestConfig.NumPartitionsProp());
        String testMetricsOutputDirPath = config.getString(TierTestConfig.TestMetricsOutputDirProp());
        String bootstrapServers = config.getString(TierTestConfig.BootstrapServerProp());
        int durationSec = config.getInt(TierTestConfig.TieringCompletedTimeoutSecProp());
        Logger logger = new Logger(debug);
        if (durationSec <= 0) {
            logger.info(String.format("Skipping tiering completion check for topic: %s as %s: %d is <= 0", topic, TierTestConfig.TieringCompletedTimeoutSecProp(), durationSec));
            return;
        }
        logger.info(String.format("Waiting a maximum of %d seconds for tiering to complete for topic: %s", durationSec, topic));
        long startTimeMs = System.currentTimeMillis();
        try (AdminClient adminClient = TierTestUtils.createAdminClient(bootstrapServers);){
            TierTestUtils.checkTieringCompleted(adminClient, topic, numPartitions, jmxAuth, jmxSsl, jmxPort, debug, testMetricsOutputDirPath, "waitTieringCompletion", durationSec);
        }
        catch (Exception e) {
            logger.error(String.format("After %d seconds, could not wait for tiering completion due to error: %s", (System.currentTimeMillis() - startTimeMs) / 1000L, e));
            throw e;
        }
        logger.info(String.format("Tiering has completed for topic: %s after %d seconds of waiting", topic, (System.currentTimeMillis() - startTimeMs) / 1000L));
    }

    private static Class[] getAndInitTestClasses(TierTestConfig config, String testType, String topic, String tierFetcherBenchmarkOutputFile) throws Exception {
        HashSet<Class> classList = new HashSet<Class>();
        Logger logger = new Logger();
        switch (testType) {
            case "test-object-store": {
                logger.info("Parsed configuration:\n" + (Object)((Object)config));
                RemoteTierObjectStoreTest.init(config);
                classList.add(RemoteTierObjectStoreTest.class);
                break;
            }
            case "test-tiered-storage-correctness": {
                logger.info("Parsed configuration:\n" + (Object)((Object)config));
                TieringFunctionalityTest.init(config);
                classList.add(TieringFunctionalityTest.class);
                break;
            }
            case "test-tiered-storage-fetch": {
                Integer s3AutoAbortSizeBytes;
                String s3EndpointOverride;
                String s3AssumeRoleArn;
                ChainedOptionsBuilder optionsBuilder = new OptionsBuilder().include(TierFetcherBenchmark.class.getSimpleName()).param("backend", new String[]{config.getString(TierTestConfig.TierBackendProp())}).param("s3Bucket", new String[]{config.getString(TierTestConfig.TierS3BucketProp())}).param("s3Region", new String[]{config.getString(TierTestConfig.TierS3RegionProp())});
                if (tierFetcherBenchmarkOutputFile == null || tierFetcherBenchmarkOutputFile.trim().isEmpty()) {
                    throw new IllegalArgumentException("--output_file with non-empty value is required for running the tiered storage fetch test.");
                }
                optionsBuilder.output(tierFetcherBenchmarkOutputFile);
                String s3CredentialsFilePath = config.getString(TierTestConfig.TierS3CredFilePathProp());
                if (s3CredentialsFilePath != null) {
                    optionsBuilder.param("s3CredentialsFilePath", new String[]{s3CredentialsFilePath});
                }
                if ((s3AssumeRoleArn = config.getString(TierTestConfig.TierS3AssumeRoleArnProp())) != null) {
                    optionsBuilder.param("s3AssumeRoleArn", new String[]{s3AssumeRoleArn});
                }
                if ((s3EndpointOverride = config.getString(TierTestConfig.TierS3EndpointOverrideProp())) != null) {
                    optionsBuilder.param("s3EndpointOverride", new String[]{s3EndpointOverride});
                }
                if ((s3AutoAbortSizeBytes = config.getInt(TierTestConfig.TierS3AutoAbortThresholdBytesProp())) != null) {
                    optionsBuilder.param("s3AutoAbortSize", new String[]{s3AutoAbortSizeBytes.toString()});
                }
                new Runner(optionsBuilder.build()).run();
                break;
            }
            case "wait-tiering-completion": {
                logger.info("Parsed configuration:\n" + (Object)((Object)config));
                if (topic == null || topic.trim().isEmpty()) {
                    throw new IllegalArgumentException("--topic with non-empty value is required for waiting for tiering completion.");
                }
                TierObjectStoreCompatibilityChecker.waitTieringCompletion(config, topic);
                break;
            }
            case "validate-configuration": {
                System.out.println((Object)config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported test type chosen: " + testType);
            }
        }
        return classList.toArray(new Class[0]);
    }
}

