/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.tier.TopicIdPartition;
import kafka.tier.compatibility.Logger;
import kafka.tier.compatibility.RemoteTierObjectStoreSupplier;
import kafka.tier.compatibility.RemoteTierObjectStoreTest$;
import kafka.tier.compatibility.TierTestConfig;
import kafka.tier.compatibility.TimeLoggingStopwatch;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\u000e\u001c\u0011\u0003\u0011c!\u0002\u0013\u001c\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003b\u0002\u0018\u0002\u0001\u0004%Ia\f\u0005\bm\u0005\u0001\r\u0011\"\u00038\u0011\u0019i\u0014\u0001)Q\u0005a!9a(\u0001a\u0001\n\u0013y\u0004bB\"\u0002\u0001\u0004%I\u0001\u0012\u0005\u0007\r\u0006\u0001\u000b\u0015\u0002!\t\u000b\u001d\u000bA\u0011\u0001%\u0007\t\u0011Z\u0002A\u0014\u0005\u0006Y)!\ta\u0014\u0005\u0006#*!\tA\u0015\u0005\u0006E*!\ta\u0019\u0005\b\u0003'QA\u0011BA\u000b\u0011\u001d\t\u0019C\u0003C\u0005\u0003KAq!!\u0010\u000b\t\u0013\ty\u0004C\u0004\u0002V)!I!a\u0016\t\u000f\u0005}#\u0002\"\u0001\u0002b!9\u00111\u000e\u0006\u0005\u0002\u0005\u0005\u0004bBA8\u0015\u0011\u0005\u0011\u0011\r\u0005\b\u0003gRA\u0011AA1\u0011\u001d\t9H\u0003C\u0001\u0003CBq!a\u001f\u000b\t\u0003\t\t\u0007C\u0004\u0002\u0000)!\t!!\u0019\t\u000f\u0005\r%\u0002\"\u0001\u0002b\u0005I\"+Z7pi\u0016$\u0016.\u001a:PE*,7\r^*u_J,G+Z:u\u0015\taR$A\u0007d_6\u0004\u0018\r^5cS2LG/\u001f\u0006\u0003=}\tA\u0001^5fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\r\nQ\"A\u000e\u00033I+Wn\u001c;f)&,'o\u00142kK\u000e$8\u000b^8sKR+7\u000f^\n\u0003\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001#\u0003My'M[3diN#xN]3TkB\u0004H.[3s+\u0005\u0001\u0004cA\u00142g%\u0011!\u0007\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\"\u0014BA\u001b\u001c\u0005u\u0011V-\\8uKRKWM](cU\u0016\u001cGo\u0015;pe\u0016\u001cV\u000f\u001d9mS\u0016\u0014\u0018aF8cU\u0016\u001cGo\u0015;pe\u0016\u001cV\u000f\u001d9mS\u0016\u0014x\fJ3r)\tA4\b\u0005\u0002(s%\u0011!\b\u000b\u0002\u0005+:LG\u000fC\u0004=\t\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013'\u0001\u000bpE*,7\r^*u_J,7+\u001e9qY&,'\u000fI\u0001\u0006I\u0016\u0014WoZ\u000b\u0002\u0001B\u0011q%Q\u0005\u0003\u0005\"\u0012qAQ8pY\u0016\fg.A\u0005eK\n,xm\u0018\u0013fcR\u0011\u0001(\u0012\u0005\by\u001d\t\t\u00111\u0001A\u0003\u0019!WMY;hA\u0005!\u0011N\\5u)\tA\u0014\nC\u0003K\u0013\u0001\u00071*\u0001\u0004d_:4\u0017n\u001a\t\u0003G1K!!T\u000e\u0003\u001dQKWM\u001d+fgR\u001cuN\u001c4jON\u0011!B\n\u000b\u0002!B\u00111EC\u0001\ngR|\u0007o^1uG\",\u0012a\u0015\t\u0003)nk\u0011!\u0016\u0006\u0003-^\u000bQA];mKNT!\u0001W-\u0002\u000b),h.\u001b;\u000b\u0003i\u000b1a\u001c:h\u0013\taVKA\u0005Ti>\u0004x/\u0019;dQ\"\u0012AB\u0018\t\u0003?\u0002l\u0011aV\u0005\u0003C^\u0013AAU;mK\u0006!1-\u00197m+\t!w\rF\u0002far\u0004\"AZ4\r\u0001\u0011)\u0001.\u0004b\u0001S\n\tA+\u0005\u0002k[B\u0011qe[\u0005\u0003Y\"\u0012qAT8uQ&tw\r\u0005\u0002(]&\u0011q\u000e\u000b\u0002\u0004\u0003:L\b\"B9\u000e\u0001\u0004\u0011\u0018A\u00014o!\r\u0019(0Z\u0007\u0002i*\u0011QO^\u0001\u000bG>t7-\u001e:sK:$(BA<y\u0003\u0011)H/\u001b7\u000b\u0003e\fAA[1wC&\u00111\u0010\u001e\u0002\t\u0007\u0006dG.\u00192mK\")Q0\u0004a\u0001}\u0006iq\u000e]3sCRLwN\u001c(b[\u0016\u00042a`A\u0007\u001d\u0011\t\t!!\u0003\u0011\u0007\u0005\r\u0001&\u0004\u0002\u0002\u0006)\u0019\u0011qA\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0001K\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0001&\u0001\nhKR$\u0016.\u001a:PE*,7\r^*u_J,GCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f;\u0005)1\u000f^8sK&!\u0011\u0011EA\u000e\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017\u0001E2sK\u0006$X\rT8h'\u0016<W.\u001a8u)\u0011\t9#a\r\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f \u0003\rawnZ\u0005\u0005\u0003c\tYC\u0001\u0006M_\u001e\u001cVmZ7f]RDq!!\u000e\u0010\u0001\u0004\t9$A\u0006tK\u001elWM\u001c;TSj,\u0007cA\u0014\u0002:%\u0019\u00111\b\u0015\u0003\u0007%sG/A\nd_6\u0004\u0018M]3J]B,Ho\u0015;sK\u0006l7\u000fF\u0003A\u0003\u0003\n\t\u0006C\u0004\u0002DA\u0001\r!!\u0012\u0002\t%t\u0007/\r\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n=\u0002\u0005%|\u0017\u0002BA(\u0003\u0013\u00121\"\u00138qkR\u001cFO]3b[\"9\u00111\u000b\tA\u0002\u0005\u0015\u0013\u0001B5oaJ\nA\u0003^3tiNKgn\u001a7f'\u0016<W.\u001a8u!V$H#\u0002\u001d\u0002Z\u0005u\u0003bBA.#\u0001\u0007\u0011qC\u0001\f_\nTWm\u0019;Ti>\u0014X\rC\u0004\u00026E\u0001\r!a\u000e\u0002%Q,7\u000f^\u00191a\t\u001bVmZ7f]R\u0004V\u000f\u001e\u000b\u0002q!\u001a!#!\u001a\u0011\u0007}\u000b9'C\u0002\u0002j]\u0013A\u0001V3ti\u0006\u0011B/Z:ueAj%iU3h[\u0016tG\u000fU;uQ\r\u0019\u0012QM\u0001\u0014i\u0016\u001cH/\r\u00191\u001b\n\u001bVmZ7f]R\u0004V\u000f\u001e\u0015\u0004)\u0005\u0015\u0014!\u0006;fgR\u0004V\u000f^*fO6,g\u000e^*b[\u0016\\U-\u001f\u0015\u0004+\u0005\u0015\u0014!\u0006;fgR$U\r\\3uKN\u000bW.Z*fO6,g\u000e\u001e\u0015\u0004-\u0005\u0015\u0014A\u0005;fgR<U\r^(cU\u0016\u001cGOU1oO\u0016D3aFA3\u0003y!Xm\u001d;HKR4\u0015-\u001b7QkR|%M[3di\u001e+GoU;dG\u0016\u001c8\u000fK\u0002\u0019\u0003K\nq\u0002^3ti\u000ec\u0017.\u001a8u\u00072|7/\u001a\u0015\u00043\u0005\u0015\u0004")
public class RemoteTierObjectStoreTest {
    public static void init(TierTestConfig tierTestConfig) {
        RemoteTierObjectStoreTest$.MODULE$.init(tierTestConfig);
    }

    @Rule
    public Stopwatch stopwatch() {
        return new TimeLoggingStopwatch();
    }

    public <T> T call(Callable<T> fn, String operationName) {
        return new Logger(RemoteTierObjectStoreTest$.MODULE$.kafka$tier$compatibility$RemoteTierObjectStoreTest$$debug()).call(fn, operationName);
    }

    private TierObjectStore getTierObjectStore() {
        return ((RemoteTierObjectStoreSupplier)RemoteTierObjectStoreTest$.MODULE$.kafka$tier$compatibility$RemoteTierObjectStoreTest$$objectStoreSupplier().get()).get();
    }

    private LogSegment createLogSegment(int segmentSize) {
        File logSegmentDir = TestUtils$.MODULE$.tempDir();
        logSegmentDir.mkdir();
        LogConfig logConfig = new LogConfig((Map)new Properties(), Predef$.MODULE$.Set().empty());
        return LogSegment$.MODULE$.open(logSegmentDir, 0L, logConfig, Time.SYSTEM, false, segmentSize, true, "");
    }

    private boolean compareInputStreams(InputStream inp1, InputStream inp2) {
        int EOS = -1;
        int ch1 = EOS + 1;
        int ch2 = EOS + 1;
        while (ch1 != EOS && ch2 != EOS && ch1 == ch2) {
            ch1 = inp1.read();
            ch2 = inp2.read();
        }
        return ch1 == ch2;
    }

    private void testSingleSegmentPut(TierObjectStore objectStore, int segmentSize) {
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false);
        LogSegment logSegment = this.createLogSegment(segmentSize);
        File segmentFile = logSegment.log().file();
        try {
            try {
                this.call(() -> {
                    objectStore.putSegment(metadata, segmentFile, logSegment.offsetIndex().file(), logSegment.offsetIndex().file(), Optional.empty(), Optional.empty(), Optional.empty());
                    return BoxedUnit.UNIT;
                }, "putSegment");
                InputStream inpStream = this.call(() -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT), "getObject").getInputStream();
                FileInputStream segmentInpStream = new FileInputStream(segmentFile);
                Assert.assertTrue((String)"Original segment file is not equal to segment file retrieved from object store", (boolean)BoxesRunTime.unboxToBoolean((Object)this.call(() -> BoxesRunTime.boxToBoolean((boolean)this.compareInputStreams(inpStream, segmentInpStream)), "compareInputStreams")));
            }
            catch (Throwable e) {
                Assert.fail((String)new StringBuilder(33).append("Failed with unexpected exception ").append(e).toString());
            }
        }
        finally {
            this.call(() -> {
                objectStore.deleteSegment(metadata);
                return BoxedUnit.UNIT;
            }, "deleteSegment");
            this.call(() -> {
                objectStore.close();
                return BoxedUnit.UNIT;
            }, "close");
        }
    }

    @Test
    public void test100BSegmentPut() {
        TierObjectStore objStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        this.testSingleSegmentPut(objStore, 100);
    }

    @Test
    public void test20MBSegmentPut() {
        TierObjectStore objStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        this.testSingleSegmentPut(objStore, (int)2.0E7);
    }

    @Test
    public void test100MBSegmentPut() {
        TierObjectStore objStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        this.testSingleSegmentPut(objStore, (int)1.0E8);
    }

    @Test
    public void testPutSegmentSameKey() {
        TierObjectStore objectStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(topicIdPartition, UUID.randomUUID(), 0, 0L, false, false, false);
        LogSegment logSegment = this.createLogSegment(10);
        File segmentFile = logSegment.log().file();
        try {
            try {
                this.call(() -> {
                    objectStore.putSegment(metadata, segmentFile, logSegment.offsetIndex().file(), logSegment.offsetIndex().file(), Optional.empty(), Optional.empty(), Optional.empty());
                    return BoxedUnit.UNIT;
                }, "putSegment");
                InputStream origInpStream = this.call(() -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT), "getObject").getInputStream();
                File newSegmentFile = this.createLogSegment(12).log().file();
                this.call(() -> {
                    objectStore.putSegment(metadata, newSegmentFile, logSegment.offsetIndex().file(), logSegment.offsetIndex().file(), Optional.empty(), Optional.empty(), Optional.empty());
                    return BoxedUnit.UNIT;
                }, "putSegment");
                FileInputStream newSegmentInpStream = new FileInputStream(newSegmentFile);
                TierObjectStoreResponse newGetObjRes = this.call(() -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT), "getObject");
                BufferedInputStream newInpStream = new BufferedInputStream(newGetObjRes.getInputStream());
                newInpStream.mark(0);
                Assert.assertFalse((String)"New segment file retrieved from object store cannot be the same as original segment file", (boolean)BoxesRunTime.unboxToBoolean((Object)this.call(() -> BoxesRunTime.boxToBoolean((boolean)this.compareInputStreams(origInpStream, newInpStream)), "compareInputStreams")));
                newInpStream.reset();
                Assert.assertTrue((String)"New segment file retrieved from object store is not equal to newly created segment file", (boolean)BoxesRunTime.unboxToBoolean((Object)this.call(() -> BoxesRunTime.boxToBoolean((boolean)this.compareInputStreams(newInpStream, newSegmentInpStream)), "compareInputStreams")));
            }
            catch (Throwable e) {
                Assert.fail((String)new StringBuilder(33).append("Failed with unexpected exception ").append(e).toString());
            }
        }
        finally {
            this.call(() -> {
                objectStore.deleteSegment(metadata);
                return BoxedUnit.UNIT;
            }, "deleteSegment");
            this.call(() -> {
                objectStore.close();
                return BoxedUnit.UNIT;
            }, "close");
        }
    }

    @Test
    public void testDeleteSameSegment() {
        TierObjectStore objectStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false);
        LogSegment logSegment = this.createLogSegment(10);
        File segmentFile = logSegment.log().file();
        this.call(() -> {
            objectStore.putSegment(metadata, segmentFile, logSegment.offsetIndex().file(), logSegment.offsetIndex().file(), Optional.empty(), Optional.empty(), Optional.empty());
            return BoxedUnit.UNIT;
        }, "putSegment");
        this.call(() -> {
            objectStore.deleteSegment(metadata);
            return BoxedUnit.UNIT;
        }, "deleteSegment");
        try {
            try {
                this.call(() -> {
                    objectStore.deleteSegment(metadata);
                    return BoxedUnit.UNIT;
                }, "deleteSegment");
            }
            catch (Throwable throwable) {
                Assert.fail((String)"No exception should have been thrown for deleting a non existent object");
            }
        }
        finally {
            this.call(() -> {
                objectStore.close();
                return BoxedUnit.UNIT;
            }, "close");
        }
    }

    @Test
    public void testGetObjectRange() {
        TierObjectStore objectStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false);
        int segmentSize = (int)1.0E7;
        LogSegment logSegment = this.createLogSegment(segmentSize);
        File segmentFile = logSegment.log().file();
        int rangeLen = (int)1000000.0;
        int startOffset = 3;
        int endOffset = rangeLen + startOffset;
        FileWriter fileWriter = new FileWriter(segmentFile);
        Random randomGen = new Random();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), segmentSize).map((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int ch = randomGen.nextInt(26) + 97;
            fileWriter.write((char)ch);
        });
        fileWriter.close();
        byte[] segmentContent = new byte[segmentSize];
        new FileInputStream(segmentFile).read(segmentContent);
        byte[] origContent = Arrays.copyOfRange(segmentContent, startOffset, endOffset);
        try {
            try {
                this.call(() -> {
                    objectStore.putSegment(metadata, segmentFile, logSegment.offsetIndex().file(), logSegment.offsetIndex().file(), Optional.empty(), Optional.empty(), Optional.empty());
                    return BoxedUnit.UNIT;
                }, "putSegment");
                InputStream segment = this.call(() -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(startOffset), Predef$.MODULE$.int2Integer(endOffset - 1)), "getObject").getInputStream();
                byte[] content = new byte[rangeLen];
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    int i = 0;
                    while (true) {
                        int ret;
                        if ((ret = segment.read(content, i, rangeLen)) == -1) {
                            throw Breaks$.MODULE$.break();
                        }
                        i += ret;
                    }
                });
                Assert.assertTrue((String)"The fetched segment data is not the size of the given range.", (origContent.length == content.length ? 1 : 0) != 0);
                Assert.assertTrue((String)"The fetched range of segment data is not the same as the original segment's range of data.", (boolean)Predef$.MODULE$.wrapByteArray(origContent).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(content)));
            }
            catch (Throwable e) {
                Assert.fail((String)new StringBuilder(33).append("Failed with unexpected exception ").append(e).toString());
            }
        }
        finally {
            this.call(() -> {
                objectStore.deleteSegment(metadata);
                return BoxedUnit.UNIT;
            }, "deleteSegment");
            this.call(() -> {
                objectStore.close();
                return BoxedUnit.UNIT;
            }, "close");
        }
    }

    @Test
    public void testGetFailPutObjectGetSuccess() {
        TierObjectStore objectStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false);
        Assert.assertThrows((String)"TierObjectStoreRetriableException is not thrown when trying to fetch a non-existent object", TierObjectStoreRetriableException.class, () -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.TIER_STATE_SNAPSHOT));
        File file = TestUtils$.MODULE$.tempFile();
        try {
            try {
                file.createNewFile();
                objectStore.putObject((TierObjectStore.ObjectStoreMetadata)metadata, file, TierObjectStore.FileType.TIER_STATE_SNAPSHOT);
                InputStream inpStream = this.call(() -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.TIER_STATE_SNAPSHOT), "getObject").getInputStream();
                FileInputStream fileInpStream = new FileInputStream(file);
                Assert.assertTrue((String)"Segment file retrieved from object store is not equal to original segment file", (boolean)BoxesRunTime.unboxToBoolean((Object)this.call(() -> BoxesRunTime.boxToBoolean((boolean)this.compareInputStreams(inpStream, fileInpStream)), "compareInputStreams")));
            }
            catch (Throwable e) {
                Assert.fail((String)new StringBuilder(33).append("Failed with unexpected exception ").append(e).toString());
            }
        }
        finally {
            this.call(() -> {
                objectStore.deleteSegment(metadata);
                return BoxedUnit.UNIT;
            }, "deleteSegment");
            this.call(() -> {
                objectStore.close();
                return BoxedUnit.UNIT;
            }, "close");
        }
    }

    @Test
    public void testClientClose() {
        TierObjectStore objectStore = this.call(() -> this.getTierObjectStore(), "createTierObjectStore");
        this.call(() -> {
            objectStore.close();
            return BoxedUnit.UNIT;
        }, "close");
        Assert.assertThrows((String)"TierObjectStoreFatalException is not thrown when trying to query a closed client.", TierObjectStoreFatalException.class, () -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false), TierObjectStore.FileType.SEGMENT));
    }
}

