/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.server.KafkaConfig;
import kafka.tier.compatibility.ObjectStoreUtils;
import kafka.tier.compatibility.RemoteTierObjectStoreTest;
import kafka.tier.compatibility.TierTestConfig;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.TierObjectStore;

public class RemoteTierObjectStoreSupplier
implements Supplier<TierObjectStore> {
    private TierTestConfig objectStoreConfig;

    public RemoteTierObjectStoreSupplier(TierTestConfig config) {
        this.objectStoreConfig = config;
    }

    @Override
    public TierObjectStore get() {
        String tierPrefix = RemoteTierObjectStoreTest.class.getSimpleName() + "-test-run-" + StrictMath.round(System.currentTimeMillis() * 1000L) + "-" + UUID.randomUUID().toString() + "/";
        Properties newObjectStoreProps = new Properties();
        newObjectStoreProps.putAll(this.objectStoreConfig.getProps());
        newObjectStoreProps.put(KafkaConfig.TierS3PrefixProp(), tierPrefix);
        return new S3TierObjectStore(ObjectStoreUtils.createS3ObjectStoreConfig(newObjectStoreProps));
    }
}

