/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils;

public class ObjectStoreUtils {
    public static S3TierObjectStoreConfig createS3ObjectStoreConfig(Properties objectStoreProps) {
        Properties props = ObjectStoreUtils.initS3ObjectStoreProperties(objectStoreProps);
        if (props.getProperty(KafkaConfig.ZkConnectProp()) == null) {
            props.put(KafkaConfig.ZkConnectProp(), TestUtils.MockZkConnect());
        }
        return new S3TierObjectStoreConfig(Optional.empty(), KafkaConfig.fromProps((Properties)props));
    }

    private static Properties initS3ObjectStoreProperties(Properties objectStoreProps) {
        Properties props = new Properties();
        props.put(KafkaConfig.TierBackendProp(), TierObjectStore.Backend.S3.getName());
        props.put(KafkaConfig.TierS3BucketProp(), objectStoreProps.getProperty(KafkaConfig.TierS3BucketProp()));
        props.put(KafkaConfig.TierS3RegionProp(), objectStoreProps.getProperty(KafkaConfig.TierS3RegionProp()));
        if (objectStoreProps.getProperty(KafkaConfig.TierS3PrefixProp()) != null) {
            props.put(KafkaConfig.TierS3PrefixProp(), objectStoreProps.getProperty(KafkaConfig.TierS3PrefixProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3CredFilePathProp()) != null) {
            props.put(KafkaConfig.TierS3CredFilePathProp(), objectStoreProps.getProperty(KafkaConfig.TierS3CredFilePathProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3SignerOverrideProp()) != null) {
            props.put(KafkaConfig.TierS3SignerOverrideProp(), objectStoreProps.getProperty(KafkaConfig.TierS3SignerOverrideProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3EndpointOverrideProp()) != null) {
            props.put(KafkaConfig.TierS3EndpointOverrideProp(), objectStoreProps.getProperty(KafkaConfig.TierS3EndpointOverrideProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3SseAlgorithmProp()) != null) {
            props.put(KafkaConfig.TierS3SseAlgorithmProp(), objectStoreProps.getProperty(KafkaConfig.TierS3SseAlgorithmProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3SseCustomerEncryptionKeyProp()) != null) {
            props.put(KafkaConfig.TierS3SseCustomerEncryptionKeyProp(), objectStoreProps.getProperty(KafkaConfig.TierS3SseCustomerEncryptionKeyProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3AutoAbortThresholdBytesProp()) != null) {
            props.put(KafkaConfig.TierS3AutoAbortThresholdBytesProp(), objectStoreProps.getProperty(KafkaConfig.TierS3AutoAbortThresholdBytesProp()));
        }
        if (objectStoreProps.getProperty(KafkaConfig.TierS3AssumeRoleArnProp()) != null) {
            props.put(KafkaConfig.TierS3AssumeRoleArnProp(), objectStoreProps.getProperty(KafkaConfig.TierS3AssumeRoleArnProp()));
        }
        return props;
    }
}

