/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Logger {
    private final boolean debug;

    public Logger(boolean debug) {
        this.debug = debug;
    }

    public Logger() {
        this.debug = true;
    }

    private String format(String msg) {
        String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        return String.format("[%s] %s\n", currentTime, msg);
    }

    private void log(String msg) {
        System.err.print(this.format(msg));
        System.err.flush();
    }

    public void infoOut(String msg) {
        System.out.print(this.format(msg));
        System.out.flush();
    }

    public void debug(String msg) {
        if (this.debug) {
            this.log("DEBUG: " + msg);
        }
    }

    public void error(String msg) {
        this.log("ERROR: " + msg);
    }

    public void warn(String msg) {
        this.log("WARNING: " + msg);
    }

    public void info(String msg) {
        this.log("INFO: " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> method, String operationName) throws Exception {
        T t;
        long before = System.nanoTime();
        try {
            t = method.call();
        }
        catch (Throwable throwable) {
            long after = System.nanoTime();
            this.debug(String.format("%s took %.3fs", operationName, (double)TimeUnit.SECONDS.convert(after - before, TimeUnit.NANOSECONDS)));
            throw throwable;
        }
        long after = System.nanoTime();
        this.debug(String.format("%s took %.3fs", operationName, (double)TimeUnit.SECONDS.convert(after - before, TimeUnit.NANOSECONDS)));
        return t;
    }
}

