/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.compatibility;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.List;
import org.junit.internal.JUnitSystem;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class CustomTextListener
extends RunListener {
    private final PrintStream writer;

    public CustomTextListener(JUnitSystem system) {
        this(system.out());
    }

    public CustomTextListener(PrintStream writer) {
        this.writer = writer;
    }

    public void testRunFinished(Result result) {
        this.printHeader(result.getRunTime());
        this.printFailures(result);
        this.printFooter(result);
    }

    public void testStarted(Description description) {
    }

    public void testFailure(Failure failure) {
    }

    public void testIgnored(Description description) {
    }

    private PrintStream getWriter() {
        return this.writer;
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        this.getWriter().println("Time taken: " + this.elapsedTimeAsString(runTime) + " seconds");
    }

    protected void printFailures(Result result) {
        List failures = result.getFailures();
        if (failures.isEmpty()) {
            return;
        }
        if (failures.size() == 1) {
            this.getWriter().println("There was " + failures.size() + " failure:");
        } else {
            this.getWriter().println("There were " + failures.size() + " failures:");
        }
        int i = 1;
        for (Failure each : failures) {
            this.printFailure(each, "" + i++);
        }
    }

    protected void printFailure(Failure each, String prefix) {
        this.getWriter().println(prefix + ") " + each.getTestHeader());
        this.getWriter().print(each.getTrimmedTrace());
    }

    protected void printFooter(Result result) {
        if (result.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + result.getRunCount() + " test" + (result.getRunCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + result.getRunCount() + ",  Failures: " + result.getFailureCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }
}

