/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!\u0002\u000b\u0016\u0011\u0003Qb!\u0002\u000f\u0016\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039\u0003\"B\u001b\u0002\t\u00039\u0003\"\u0002\u001c\u0002\t\u00039d\u0001\u0002\u000f\u0016\u00011CQ\u0001\n\u0004\u0005\u00025Cqa\u0014\u0004C\u0002\u0013\u0005\u0001\u000b\u0003\u0004U\r\u0001\u0006I!\u0015\u0005\u0006+\u001a!\tA\u0016\u0005\u0006[\u001a!\tA\u001c\u0005\u0006g\u001a!\t\u0001\u001e\u0005\u0006s\u001a!\tA\u001f\u0005\u0007\u007f\u001a!I!!\u0001\t\u000f\u0005ed\u0001\"\u0001\u0002|!9\u0011Q\u0011\u0004\u0005\u0002\u0005\u001d\u0005bBAI\r\u0011\u0005\u00111\u0013\u0005\b\u0003;3A\u0011AAP\u0011\u001d\tIK\u0002C\u0001\u0003W\u000b\u0011#T3uC\u0012\fG/Y\"bG\",G+Z:u\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u0001\u0001CA\u000e\u0002\u001b\u0005)\"!E'fi\u0006$\u0017\r^1DC\u000eDW\rV3tiN\u0011\u0011A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0012a\u0004>l\u0007\u0006\u001c\u0007.\u001a)s_ZLG-\u001a:\u0015\u0003!\u00022!\u000b\u00193\u001b\u0005Q#BA\u0016-\u0003\u0019\u0019HO]3b[*\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005ER#AB*ue\u0016\fW\u000e\u0005\u0002\u001cg%\u0011A'\u0006\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001b\r\f7\r[3Qe>4\u0018\u000eZ3s\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\u0007aZT\b\u0005\u0002 s%\u0011!\b\t\u0002\u0005+:LG\u000fC\u0003=\u000b\u0001\u0007!'A\u0003dC\u000eDW\rC\u0003?\u000b\u0001\u0007q(A\u0004sKF,Xm\u001d;\u0011\u0005\u0001SU\"A!\u000b\u0005\t\u001b\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u0011+\u0015AB2p[6|gN\u0003\u0002\u0019\r*\u0011q\tS\u0001\u0007CB\f7\r[3\u000b\u0003%\u000b1a\u001c:h\u0013\tY\u0015IA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0014\u0005\u0019qB#\u0001(\u0011\u0005m1\u0011a\u00032s_.,'/\u00129pG\",\u0012!\u0015\t\u0003?IK!a\u0015\u0011\u0003\t1{gnZ\u0001\rEJ|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\"O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006tuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0003q]CQ\u0001\u0010\u0006A\u0002IBCAC-fMB\u0011!lY\u0007\u00027*\u0011A,X\u0001\taJ|g/\u001b3fe*\u0011alX\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005\u0001\f\u0017a\u00026va&$XM\u001d\u0006\u0003E\"\u000bQA[;oSRL!\u0001Z.\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003\u001d\f\u0013!\u000e\u0015\u0003\u0015%\u0004\"A[6\u000e\u0003uK!\u0001\\/\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCR\u0011\u0001h\u001c\u0005\u0006y-\u0001\rA\r\u0015\u0005\u0017e+\u0017\u000fL\u0001hQ\tY\u0011.A\u0016hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*Z1eKJtu\u000e^!wC&d\u0017M\u00197f)\tAT\u000fC\u0003=\u0019\u0001\u0007!\u0007\u000b\u0003\r3\u0016<H&A4)\u00051I\u0017!N4fiR{\u0007/[2NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK>sG*Z1eKJ$\"\u0001O>\t\u000bqj\u0001\u0019\u0001\u001a)\t5IV- \u0017\u0002O\"\u0012Q\"[\u00019m\u0016\u0014\u0018NZ=U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:Pe\u0016sG\r]8j]Rtu\u000e^!wC&d\u0017M\u00197f)=A\u00141AA\u0003\u0003\u001f\tY%a\u0017\u0002`\u0005=\u0004\"\u0002\u001f\u000f\u0001\u0004\u0011\u0004bBA\u0004\u001d\u0001\u0007\u0011\u0011B\u0001\u0016[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3Ce>\\WM]%e!\ry\u00121B\u0005\u0004\u0003\u001b\u0001#aA%oi\"9\u0011\u0011\u0003\bA\u0002\u0005M\u0011a\u00022s_.,'o\u001d\t\u0007\u0003+\tY\"a\b\u000e\u0005\u0005]!bAA\rA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\u0004'\u0016\f\b\u0003BA\u0011\u0003\u000brA!a\t\u0002@9!\u0011QEA\u001e\u001d\u0011\t9#!\u000f\u000f\t\u0005%\u0012q\u0007\b\u0005\u0003W\t)D\u0004\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t$G\u0001\u0007yI|w\u000e\u001e \n\u0003%K!a\u0012%\n\u0005a1\u0015B\u0001#F\u0013\r\tidQ\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\t%a\u0011\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003{\u0019\u0015\u0002BA$\u0003\u0013\u0012A#\u00169eCR,W*\u001a;bI\u0006$\u0018M\u0011:pW\u0016\u0014(\u0002BA!\u0003\u0007Bq!!\u0014\u000f\u0001\u0004\ty%\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)fQ\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI&a\u0015\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0005uc\u00021\u0001\u0002\n\u00051A.Z1eKJDq!!\u0019\u000f\u0001\u0004\t\u0019'A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N\"\u0002\u0011A\u0014x\u000e^8d_2LA!!\u001c\u0002h\t1QI\u001d:peNDq!!\u001d\u000f\u0001\u0004\t\u0019(A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\bcA\u0010\u0002v%\u0019\u0011q\u000f\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u0019s-\u001a;U_BL7-T3uC\u0012\fG/\u0019*fa2L7-\u0019(pi\u00063\u0018-\u001b7bE2,Gc\u0001\u001d\u0002~!)Ah\u0004a\u0001e!*q\"W3\u0002\u00022\nq\r\u000b\u0002\u0010S\u0006yr-\u001a;U_BL7-T3uC\u0012\fG/Y%te:{G/\u0011<bS2\f'\r\\3\u0015\u0007a\nI\tC\u0003=!\u0001\u0007!\u0007K\u0003\u00113\u0016\fi\tL\u0001hQ\t\u0001\u0012.\u0001\u0019hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC^KG\u000f\u001b(p]N+\b\u000f]8si\u0016$7+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u000b\u0004q\u0005U\u0005\"\u0002\u001f\u0012\u0001\u0004\u0011\u0004&B\tZK\u0006eE&A4)\u0005EI\u0017AL4fi\u0006c\u0017N^3Ce>\\WM]:TQ>,H\u000e\u001a(pi\n+W*\u001e;bi\u0016$')_+qI\u0006$XmQ1dQ\u0016$2\u0001OAQ\u0011\u0015a$\u00031\u00013Q\u0015\u0011\u0012,ZASY\u00059\u0007F\u0001\nj\u0003%\"Xm\u001d;HKR\u001cE.^:uKJlU\r^1eCR\fw+\u001b;i\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2bgR\u0019\u0001(!,\t\u000bq\u001a\u0002\u0019\u0001\u001a)\u000bMIV-!--\u0005\u0005M\u0016%\u0001\u0014)\u0005MI\u0007")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092);
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$4) {
        return x$4.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$4))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

