/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\u0002\u001dBQ\u0001\u000f\u0001\u0005\u0002\u001dBQA\u000f\u0001\u0005\u0002\u001dBQ\u0001\u0010\u0001\u0005\u0002\u001dBQA\u0010\u0001\u0005\u0002\u001dBQ\u0001\u0011\u0001\u0005\u0002\u001dBQA\u0011\u0001\u0005\u0002\u001dBQ\u0001\u0012\u0001\u0005\u0002\u001dBQA\u0012\u0001\u0005\u0002\u001dBQ\u0001\u0013\u0001\u0005\u0002\u001dBQA\u0013\u0001\u0005\u0002\u001dBQ\u0001\u0014\u0001\u0005\u0002\u001dBQA\u0014\u0001\u0005\n=CQ\u0001\u0019\u0001\u0005\n\u0005DQ!\u001b\u0001\u0005\u0002\u001dBQa\u001b\u0001\u0005\u0002\u001dBQ!\u001c\u0001\u0005\u0002\u001dBQa\u001c\u0001\u0005\u0002\u001dBQ!\u001d\u0001\u0005\nI\u0014Q\u0002T8h\u0007>tg-[4UKN$(BA\f\u0019\u0003\rawn\u001a\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011AF\u0001,K:\u001cXO]3O_N#\u0018\r^5d\u0013:LG/[1mSj\fG/[8o\u001fJ$WM\u001d#fa\u0016tG-\u001a8dsR\t\u0001\u0006\u0005\u0002\u001eS%\u0011!F\b\u0002\u0005+:LG\u000f\u000b\u0002\u0003YA\u0011QFN\u0007\u0002])\u0011q\u0006M\u0001\u0004CBL'BA\u00193\u0003\u001dQW\u000f]5uKJT!a\r\u001b\u0002\u000b),h.\u001b;\u000b\u0003U\n1a\u001c:h\u0013\t9dF\u0001\u0003UKN$\u0018A\u0006;fgR\\\u0015MZ6b\u0007>tg-[4U_B\u0013x\u000e]:)\u0005\ra\u0013A\u0005;fgR4%o\\7Qe>\u00048/R7qifD#\u0001\u0002\u0017\u0002)Q,7\u000f\u001e$s_6\u0004&o\u001c9t\u0013:4\u0018\r\\5eQ\t)A&\u0001\u0010uKN$\u0018J\u001c<bY&$7i\\7qC\u000e$\u0018n\u001c8MC\u001e\u001cuN\u001c4jO\"\u0012a\u0001L\u0001&g\"|W\u000f\u001c3WC2LG-\u0019;f)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c8i\u001c8gS\u001eD#a\u0002\u0017\u0002\u001fQ,7\u000f\u001e+p\u0011RlG\u000eV1cY\u0016D#\u0001\u0003\u0017\u0002\u0015Q,7\u000f\u001e+p\u0011RlG\u000e\u000b\u0002\nY\u0005\tB/Z:u)>,eN]5dQ\u0016$'k\u001d;)\u0005)a\u0013!\u0003;fgR$vNU:uQ\tYA&\u0001\nuKN$x)\u001a;D_:4\u0017n\u001a,bYV,\u0007F\u0001\u0007-\u0003\u0015\"Xm\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jON\f5\u000fT8hO\u0006\u0014G.Z*ue&tw\r\u000b\u0002\u000eY\u00059\u0011n\u001d,bY&$GC\u0001)T!\ti\u0012+\u0003\u0002S=\t9!i\\8mK\u0006t\u0007\"\u0002+\u000f\u0001\u0004)\u0016aC2p]\u001aLwMV1mk\u0016\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u001f\u001b\u0005I&B\u0001.\u001b\u0003\u0019a$o\\8u}%\u0011ALH\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]=\u0005)\u0012m]:feR\u0004&o\u001c9feRL\u0018J\u001c<bY&$Gc\u0001\u0015cI\")1m\u0004a\u0001+\u0006!a.Y7f\u0011\u0015)w\u00021\u0001g\u0003\u00191\u0018\r\\;fgB\u0019Qd\u001a\u000f\n\u0005!t\"A\u0003\u001fsKB,\u0017\r^3e}\u0005\tC/Z:u\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>tG)\u001a:jm\u0016$\u0007K]8qg\"\u0012\u0001\u0003L\u0001)i\u0016\u001cH\u000fT8dC2dun\u001a*fi\u0016tG/[8o\t\u0016\u0014\u0018N^3e\t\u00164\u0017-\u001e7u!J|\u0007o\u001d\u0015\u0003#1\n!\u0004^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000e\u0015:paND#A\u0005\u0017\u0002CQ,7\u000f^%om\u0006d\u0017\u000e\u001a'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:)\u0005Ma\u0013a\t3p)\u0016\u001cH/\u00138wC2LG\rT8dC2dun\u001a*fi\u0016tG/[8o!J|\u0007o\u001d\u000b\tgz\f9!!\u0005\u0002\u0016A\u0011A\u000f`\u0007\u0002k*\u0011ao^\u0001\u0007G>tg-[4\u000b\u0005aL\u0018AB2p[6|gN\u0003\u0002\u001au*\u00111\u0010N\u0001\u0007CB\f7\r[3\n\u0005u,(aD\"p]\u001aLw-\u0012=dKB$\u0018n\u001c8\t\r}$\u0002\u0019AA\u0001\u0003AawnY1m%\u0016$XM\u001c;j_:l5\u000fE\u0002\u001e\u0003\u0007I1!!\u0002\u001f\u0005\u0011auN\\4\t\u000f\u0005%A\u00031\u0001\u0002\f\u0005\u0019Bn\\2bYJ+G/\u001a8uS>t')\u001f;fgB\u0019Q$!\u0004\n\u0007\u0005=aDA\u0002J]RDq!a\u0005\u0015\u0001\u0004\tY!\u0001\bsKR,g\u000e^5p]\nKH/Z:\t\u000f\u0005]A\u00031\u0001\u0002\u0002\u0005Y!/\u001a;f]RLwN\\'t\u0001")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableOnceOps)LogConfig$.MODULE$.configNames().filter((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$.version(), logProps.get(LogConfig$.MODULE$.MessageFormatVersionProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig$.MODULE$.validate(props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName()));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(LogConfig$.MODULE$.RetentionBytesProp(), "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(LogConfig$.MODULE$.extractLogConfigMap(kafkaConfig), topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)retentionMs, (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionMs(), (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)Defaults$.MODULE$.RetentionSize(), (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(2000));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Integer.toString(1000));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Integer.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.remoteLogConfig().localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.remoteLogConfig().localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.RetentionBytesProp(), Integer.toString(retentionBytes));
        props.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionMsProp(), Long.toString(localRetentionMs));
        props.put(LogConfig$.MODULE$.LocalLogRetentionBytesProp(), Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new LogConfig((Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig$.MODULE$.configsWithNoServerDefaults().contains((Object)config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            return;
        }
        String string2 = LogConfig$.MODULE$.RetentionBytesProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string3 = LogConfig$.MODULE$.RetentionMsProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
            return;
        }
        String string4 = LogConfig$.MODULE$.CleanupPolicyProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
            return;
        }
        String string5 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
            return;
        }
        String string6 = LogConfig$.MODULE$.MinInSyncReplicasProp();
        if (!(string6 != null ? !string6.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
            return;
        }
        String string7 = LogConfig$.MODULE$.MessageFormatVersionProp();
        if (!(string7 != null ? !string7.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{""}));
            return;
        }
        String string8 = LogConfig$.MODULE$.RemoteLogStorageEnableProp();
        if (!(string8 != null ? !string8.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
            return;
        }
        String string9 = LogConfig$.MODULE$.LocalLogRetentionMsProp();
        if (!(string9 != null ? !string9.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
            return;
        }
        String string10 = LogConfig$.MODULE$.LocalLogRetentionBytesProp();
        if (!(string10 != null ? !string10.equals(name) : name != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
            return;
        }
        $this.assertPropertyInvalid(name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
    }
}

