/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001B\u0011#\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019\u0011\u0005\u0001)A\u0005\u007f!91\t\u0001b\u0001\n\u0003!\u0005BB'\u0001A\u0003%Q\tC\u0003O\u0001\u0011\u0005q\nC\u0003a\u0001\u0011\u0005q\nC\u0003c\u0001\u0011\u0005q\nC\u0003e\u0001\u0011\u0005q\nC\u0003g\u0001\u0011\u0005q\nC\u0003i\u0001\u0011\u0005q\nC\u0003k\u0001\u0011\u0005q\nC\u0003m\u0001\u0011\u0005q\nC\u0003o\u0001\u0011\u0005q\nC\u0003q\u0001\u0011\u0005q\nC\u0003s\u0001\u0011\u0005q\nC\u0003u\u0001\u0011\u0005q\nC\u0003w\u0001\u0011\u0005q\nC\u0003y\u0001\u0011\u0005q\nC\u0003{\u0001\u0011\u0005q\nC\u0003}\u0001\u0011\u0005q\nC\u0003\u007f\u0001\u0011\u0005q\n\u0003\u0004\u0002\u0002\u0001!\ta\u0014\u0005\u0007\u0003\u000b\u0001A\u0011A(\t\r\u0005%\u0001\u0001\"\u0001P\u0011\u0019\ti\u0001\u0001C\u0001\u001f\"1\u0011\u0011\u0003\u0001\u0005\u0002=Ca\u0001\u001f\u0001\u0005\n\u0005U\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0005\u0003\u001b\u0012q\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$Vm\u001d;\u000b\u0005\r\"\u0013a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\n\u0014\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011AI\u0001\u0005i&lW-F\u00017!\t9$(D\u00019\u0015\tId%A\u0003vi&d7/\u0003\u0002<q\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012a\u0010\t\u0003W\u0001K!!\u0011\u0017\u0003\t1{gnZ\u0001\faJ|G-^2fe&#\u0007%A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0011a\u0017M\\4\u000b\u0003)\u000bAA[1wC&\u0011Aj\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004\u0013a\u0005;fgRLe.\u001b;jC2L'0Z#q_\u000eDG#\u0001)\u0011\u0005-\n\u0016B\u0001*-\u0005\u0011)f.\u001b;)\u0005!!\u0006CA+_\u001b\u00051&BA,Y\u0003\r\t\u0007/\u001b\u0006\u00033j\u000bqA[;qSR,'O\u0003\u0002\\9\u0006)!.\u001e8ji*\tQ,A\u0002pe\u001eL!a\u0018,\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHOT8s[\u0006dW\t]8dQ\n+X\u000e\u001d\u0015\u0003\u0013Q\u000b\u0001\u0006^3ti\n+X\u000e]#q_\u000eDgj\u001c;BY2|w/\u001a3JM\u0016\u0003xn\u00195t\u000bbD\u0017-^:uK\u0012D#A\u0003+\u0002UQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3Va\u0012\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4Fa>\u001c\u0007NQ;na\"\u00121\u0002V\u00014i\u0016\u001cH\u000fV8mKJ\fG/Z+qI\u0006$X\rV5nKJ+7/\u001a;EkJLgn\u001a)s_\u0012,8-\u001a:JIJ{G/\u0019;j_:D#\u0001\u0004+\u0002QQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3US6,7\u000b[5gi\u0012+(/\u001b8h\u0003\u0012$\u0007+\u0019:uSRLwN\\:)\u00055!\u0016\u0001\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&tw\r\u0015:fa\u0006\u0014XmQ8n[&$\bF\u0001\bU\u0003\u001d\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oOB\u0013X\r]1sK\u0006\u0013wN\u001d;)\u0005=!\u0016!\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&twmQ8na2,G/Z\"p[6LG\u000f\u000b\u0002\u0011)\u0006AC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u001cu.\u001c9mKR,\u0017IY8si\"\u0012\u0011\u0003V\u0001&i\u0016\u001cHOR3oG\u0016\u0004&o\u001c3vG\u0016\u0014\u0018I\u001a;fe\u0016\u0003xn\u00195t\u000bbD\u0017-^:uK\u0012D#A\u0005+\u0002YQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'OT8u\u00032dwn^3e\u0013\u001aLEoV8vY\u0012|e/\u001a:gY><\bFA\nU\u0003Q!Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI\"\u0012A\u0003V\u0001#i\u0016\u001cHOU8uCR,\u0007K]8ek\u000e,'/\u00133J]>swm\\5oON#\u0018\r^3)\u0005U!\u0016a\n;fgR\u0014v\u000e^1uKB\u0013x\u000eZ;dKJLE-\u00138Qe\u0016\u0004\u0018M]3BE>\u0014Ho\u0015;bi\u0016D#A\u0006+\u0002QQ,7\u000f\u001e*pi\u0006$X\r\u0015:pIV\u001cWM]%e\u0013:\u0004&/\u001a9be\u0016\u001cu.\\7jiN#\u0018\r^3)\u0005]!\u0016A\f;fgR\fE\u000f^3naR,G-\u00129pG\"\u0014U/\u001c9XSRDg*Z<ms\u000e\u0013X-\u0019;fI6+G/\u00193bi\u0006D#\u0001\u0007+\u0002KQ,7\u000f^#q_\u000eD')^7q/&$\bnQ;se\u0016tG/\u00129pG\"\u0004&o\u001c<jI\u0016$\u0007FA\rU\u0003\r\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\u0019\u0006\u001cH/\u00129pG\"D#A\u0007+\u0002KQ,7\u000f^!ui\u0016l\u0007\u000f^3e\u000bB|7\r\u001b\"v[B<\u0016\u000e\u001e5GK:\u001cW\rZ#q_\u000eD\u0007FA\u000eU\u0003\u0011\"Xm\u001d;Ue\u0006t7/Y2uS>t7\u000b^1uK&#\u0017I\u001c3OC6,W*\u00199qS:<\u0007F\u0001\u000fU\u0003\u0005\"Xm\u001d;BY2$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$Xm]!sK6\u000b\u0007\u000f]3eQ\tiB\u000bF\u0002Q\u0003/Aq!!\u0007\u001f\u0001\u0004\tY\"A\u0003ti\u0006$X\rE\u00024\u0003;I1!a\b#\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-A\u0014qe\u0016\u0004\u0018M]3Tk\u000e\u001cWm]:gk2Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDG\u0003CA\u0013\u0003W\t)$!\u0012\u0011\u0007M\n9#C\u0002\u0002*\t\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u0011QF\u0010A\u0002\u0005=\u0012a\u0003;y]6+G/\u00193bi\u0006\u00042aMA\u0019\u0013\r\t\u0019D\t\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\b\u0003oy\u0002\u0019AA\u001d\u0003U)\u0007\u0010]3di\u0016$\u0007K]8ek\u000e,'/\u00129pG\"\u0004RaKA\u001e\u0003\u007fI1!!\u0010-\u0005\u0019y\u0005\u000f^5p]B\u00191&!\u0011\n\u0007\u0005\rCFA\u0003TQ>\u0014H\u000fC\u0005\u0002H}\u0001\n\u00111\u0001\u0002J\u0005\u0019an\\<\u0011\t-\nYdP\u00012aJ,\u0007/\u0019:f'V\u001c7-Z:tMVd\u0017J\\2sK6,g\u000e\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tyE\u000b\u0003\u0002J\u0005E3FAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uC&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0019\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()));
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().milliseconds() - 1L))));
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)fencingTransitMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)fencingTransitMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testRotateProducerIdInOngoingState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareAbortState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareCommitState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$));
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        Either result = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, l, x$9).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds());
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED), (Object)result);
    }

    @Test
    public void testTransactionStateIdAndNameMapping() {
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)state -> {
            TransactionMetadataTest.$anonfun$testTransactionStateIdAndNameMapping$1(state);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllTransactionStatesAreMapped() {
        Set unmatchedStates = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{Empty$.MODULE$, Ongoing$.MODULE$, PrepareCommit$.MODULE$, PrepareAbort$.MODULE$, CompleteCommit$.MODULE$, CompleteAbort$.MODULE$, PrepareEpochFence$.MODULE$, Dead$.MODULE$}));
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMetadataTest.$anonfun$testAllTransactionStatesAreMapped$1(unmatchedStates, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)unmatchedStates);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, -1, 30000, state, x$8, l, x$9);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    private TxnTransitMetadata prepareSuccessfulIncrementProducerEpoch(TransactionMetadata txnMetadata, Option<Object> expectedProducerEpoch, Option<Object> now) {
        Either result = txnMetadata.prepareIncrementProducerEpoch(30000, expectedProducerEpoch, BoxesRunTime.unboxToLong((Object)now.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.time().milliseconds())));
        return (TxnTransitMetadata)result.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(42).append("prepareIncrementProducerEpoch failed with ").append(result).toString());
        });
    }

    private Option<Object> prepareSuccessfulIncrementProducerEpoch$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$testTransactionStateIdAndNameMapping$1(Product state) {
        Assertions.assertEquals((Object)state, (Object)TransactionState$.MODULE$.fromId(((TransactionState)state).id()));
        Assertions.assertEquals((Object)new Some((Object)state), (Object)TransactionState$.MODULE$.fromName(((TransactionState)state).name()));
        Product product = state;
        Dead$ dead$ = Dead$.MODULE$;
        if (product == null || !product.equals(dead$)) {
            org.apache.kafka.clients.admin.TransactionState clientTransactionState = org.apache.kafka.clients.admin.TransactionState.parse((String)((TransactionState)state).name());
            Assertions.assertEquals((Object)((TransactionState)state).name(), (Object)clientTransactionState.toString());
            Assertions.assertNotEquals((Object)org.apache.kafka.clients.admin.TransactionState.UNKNOWN, (Object)clientTransactionState);
        }
    }

    public static final /* synthetic */ void $anonfun$testAllTransactionStatesAreMapped$1(Set unmatchedStates$1, Product x0$1) {
        if (Empty$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Empty$.MODULE$));
            return;
        }
        if (Ongoing$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Ongoing$.MODULE$));
            return;
        }
        if (PrepareCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareCommit$.MODULE$));
            return;
        }
        if (PrepareAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareAbort$.MODULE$));
            return;
        }
        if (CompleteCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteCommit$.MODULE$));
            return;
        }
        if (CompleteAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteAbort$.MODULE$));
            return;
        }
        if (PrepareEpochFence$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareEpochFence$.MODULE$));
            return;
        }
        if (Dead$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Dead$.MODULE$));
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

