/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\u0013'\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005\u0002eBQA\u0013\u0001\u0005\u0002e2A\u0001\u0014\u0001\u0001\u001b\")A\u0007\u0002C\u0001#\"9A\u000b\u0002a\u0001\n\u0003)\u0006b\u00020\u0005\u0001\u0004%\ta\u0018\u0005\u0007E\u0012\u0001\u000b\u0015\u0002,\t\u000f\r$!\u0019!C\u0001I\"1Q\u0010\u0002Q\u0001\n\u0015DqA \u0003A\u0002\u0013\u0005q\u0010C\u0005\u0002\b\u0011\u0001\r\u0011\"\u0001\u0002\n!A\u0011Q\u0002\u0003!B\u0013\t\t\u0001\u0003\u0005\u0002\u0010\u0011\u0001\r\u0011\"\u0001\u0000\u0011%\t\t\u0002\u0002a\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002\u0018\u0011\u0001\u000b\u0015BA\u0001\u0011%\tI\u0002\u0002a\u0001\n\u0003\tY\u0002C\u0005\u0002$\u0011\u0001\r\u0011\"\u0001\u0002&!A\u0011\u0011\u0006\u0003!B\u0013\ti\u0002\u0003\u0005\u0002,\u0011\u0001\r\u0011\"\u0001\u0000\u0011%\ti\u0003\u0002a\u0001\n\u0003\ty\u0003\u0003\u0005\u00024\u0011\u0001\u000b\u0015BA\u0001\u0011\u001d\t)\u0004\u0002C!\u0003o1a!a\u0012\u0001\u0001\u0005%\u0003B\u0002\u001b\u0019\t\u0003\t\t\u0006C\u0004U1\u0001\u0007I\u0011A+\t\u0011yC\u0002\u0019!C\u0001\u0003+BaA\u0019\r!B\u00131\u0006bBA-1\u0011\u0005\u00131\f\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003WB\u0001\"!\u001f\u0001A\u0003%\u0011Q\u000e\u0005\b\u0003w\u0002A\u0011BA?\u0011\u0019\ti\t\u0001C\u0001s!1\u0011\u0011\u0013\u0001\u0005\u0002eBq!!&\u0001\t\u0013\t9\nC\u0004\u0002(\u0002!I!!+\u00035\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$Vm\u001d;\u000b\u0005\u001dB\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\ta%\u0001\nuKN$8I]3bi\u0016\fe\u000eZ\"m_N,G#\u0001\u001e\u0011\u0005=Z\u0014B\u0001\u001f1\u0005\u0011)f.\u001b;)\u0005\tq\u0004CA I\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\r\u0006)!.\u001e8ji*\tq)A\u0002pe\u001eL!!\u0013!\u0003\tQ+7\u000f^\u0001\fi\u0016\u001cH\u000fU;cY&\u001c\b\u000e\u000b\u0002\u0004}\t9Rj\\2l\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$XM]\n\u0004\t9r\u0005CA\u001cP\u0013\t\u0001fEA\nNKR\fG-\u0019;b':\f\u0007o\u001d5piR,'\u000fF\u0001S!\t\u0019F!D\u0001\u0001\u0003\u0015IW.Y4f+\u00051\u0006CA,]\u001b\u0005A&B\u0001+Z\u0015\tY#L\u0003\u0002\\\r\u00061\u0011\r]1dQ\u0016L!!\u0018-\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003%IW.Y4f?\u0012*\u0017\u000f\u0006\u0002;A\"9\u0011mBA\u0001\u0002\u00041\u0016a\u0001=%c\u00051\u0011.\\1hK\u0002\nqAZ1jYV\u0014X-F\u0001f!\r1w.]\u0007\u0002O*\u0011\u0001.[\u0001\u0007CR|W.[2\u000b\u0005)\\\u0017AC2p]\u000e,(O]3oi*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A<'aD!u_6L7MU3gKJ,gnY3\u0011\u0005IThBA:y\u001d\t!x/D\u0001v\u0015\t1H&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011\u0011\u0010M\u0001\ba\u0006\u001c7.Y4f\u0013\tYHPA\u0005UQJ|w/\u00192mK*\u0011\u0011\u0010M\u0001\tM\u0006LG.\u001e:fA\u0005!\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR,\"!!\u0001\u0011\u0007=\n\u0019!C\u0002\u0002\u0006A\u0012A\u0001T8oO\u0006A\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR|F%Z9\u0015\u0007i\nY\u0001\u0003\u0005b\u0019\u0005\u0005\t\u0019AA\u0001\u0003U\t7\r^5wKNs\u0017\r]:i_R|eMZ:fi\u0002\n1\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR\fq\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR|F%Z9\u0015\u0007i\n)\u0002\u0003\u0005b\u001f\u0005\u0005\t\u0019AA\u0001\u0003Q\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005\u0011\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i+\t\ti\u0002E\u00020\u0003?I1!!\t1\u0005\rIe\u000e^\u0001\u0017aJ,goQ8n[&$H/\u001a3Fa>\u001c\u0007n\u0018\u0013fcR\u0019!(a\n\t\u0011\u0005\u0014\u0012\u0011!a\u0001\u0003;\t1\u0003\u001d:fm\u000e{W.\\5ui\u0016$W\t]8dQ\u0002\n\u0001\u0004\u001d:fm2\u000b7\u000f^\"p]R\f\u0017N\\3e\u0019><G+[7f\u0003q\u0001(/\u001a<MCN$8i\u001c8uC&tW\r\u001a'pORKW.Z0%KF$2AOA\u0019\u0011!\tW#!AA\u0002\u0005\u0005\u0011!\u00079sKZd\u0015m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\u0002\n!#\\1zE\u0016\u001cF/\u0019:u':\f\u0007o\u001d5piR1\u0011\u0011HA \u0003\u0007\u00022aLA\u001e\u0013\r\ti\u0004\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t\te\u0006a\u0001\u0003\u0003\tA\u0003\\1ti\u000e{g\u000e^1j]\u0016$Gj\\4US6,\u0007BBA#/\u0001\u0007a+\u0001\u0005oK^LU.Y4f\u0005UiunY6NKR\fG-\u0019;b!V\u0014G.[:iKJ\u001cB\u0001\u0007\u0018\u0002LA\u0019q'!\u0014\n\u0007\u0005=cEA\tNKR\fG-\u0019;b!V\u0014G.[:iKJ$\"!a\u0015\u0011\u0005MCBc\u0001\u001e\u0002X!9\u0011mGA\u0001\u0002\u00041\u0016a\u00029vE2L7\u000f\u001b\u000b\u0006u\u0005u\u0013q\r\u0005\b\u0003?j\u0002\u0019AA1\u0003\u0015!W\r\u001c;b!\r9\u00161M\u0005\u0004\u0003KB&!D'fi\u0006$\u0017\r^1EK2$\u0018\r\u0003\u0004\u0002Fu\u0001\rAV\u0001\u0007\r>{u,\u0013#\u0016\u0005\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0014,\u0001\u0004d_6lwN\\\u0005\u0005\u0003o\n\tH\u0001\u0003Vk&$\u0017a\u0002$P\u001f~KE\tI\u0001\u0014O\u0016tWM]1uK6\u000bg.\u001f*fG>\u0014Hm\u001d\u000b\u0006u\u0005}\u0014\u0011\u0012\u0005\b\u0003\u0003\u0003\u0003\u0019AAB\u0003!a\u0017n\u001d;f]\u0016\u0014\bcA\u001c\u0002\u0006&\u0019\u0011q\u0011\u0014\u0003-\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJDq!a#!\u0001\u0004\t\t!A\u0005f]\u0012|eMZ:fi\u0006IC/Z:u\u0011\u0006tG\r\\3D_6l\u0017\u000e^:XSRDgj\\*oCB\u001c\bn\u001c;uKJ$UMZ5oK\u0012D#!\t \u0002%Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\u0015\u0003Ey\nqB]3hSN$XM\u001d\"s_.,'o\u001d\u000b\bu\u0005e\u00151TAS\u0011\u001d\t\ti\ta\u0001\u0003\u0007Cq!!($\u0001\u0004\ty*A\u0005ce>\\WM]%egB)!/!)\u0002\u001e%\u0019\u00111\u0015?\u0003\u0011%#XM]1cY\u0016Dq!a#$\u0001\u0004\t\t!A\u000ede\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u001f:,\u0007+\u0019:uSRLwN\u001c\u000b\bu\u0005-\u0016QVA\\\u0011\u001d\t\t\t\na\u0001\u0003\u0007Cq!a,%\u0001\u0004\t\t,\u0001\u0005sKBd\u0017nY1t!\u0015\u0011\u00181WA\u000f\u0013\r\t)\f \u0002\u0004'\u0016\f\bbBAFI\u0001\u0007\u0011\u0011\u0001")
public class BrokerMetadataListenerTest {
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");

    @Test
    public void testCreateAndClose() {
        new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000000L, (Option)None$.MODULE$).close();
    }

    @Test
    public void testPublish() {
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000000L, (Option)None$.MODULE$);){
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0))));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)0, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)200L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0))));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true), (Object)delta.clusterDelta().broker(1));
                }
            }).get();
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000L, (Option)None$.MODULE$);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000L, (Option)new Some((Object)snapshotter));){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, scala.collection.immutable.Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(0).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), (short)0))));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

