/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.log.LogManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rBq!\n\u0001A\u0002\u0013\u0005a\u0005C\u0004+\u0001\u0001\u0007I\u0011A\u0016\t\rQ\u0002\u0001\u0015)\u0003(\u0011\u001d)\u0004A1A\u0005\u0002YBaa\u0010\u0001!\u0002\u00139\u0004b\u0002!\u0001\u0005\u0004%\tA\u000e\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001c\t\u000f\t\u0003!\u0019!C\u0001\u0007\"1A\n\u0001Q\u0001\n\u0011Cq!\u0014\u0001C\u0002\u0013\u00051\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0012\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006S\u0002!\t\u0001\u001a\u0005\u0006W\u0002!\t\u0001\u001a\u0005\u0006[\u0002!\t\u0001\u001a\u0005\u0006_\u0002!I\u0001\u001d\u0005\t\u0003C\u0001\u0001\u0015\"\u0003\u0002$!1\u0011Q\u0007\u0001\u0005\u0002\u0011Da!a\u000e\u0001\t\u0003!\u0007BBA\u001e\u0001\u0011\u0005AM\u0001\nTKJ4XM]*ikR$wn\u001e8UKN$(BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010!\u001b\u0005A\u0012BA\u0011\u0019\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"a\b\u0001\u0002\r\r|gNZ5h+\u00059\u0003CA\u0010)\u0013\tI\u0003DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fC\u00044\u0007\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\t!|7\u000f^\u000b\u0002oA\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005Y\u0006twMC\u0001=\u0003\u0011Q\u0017M^1\n\u0005yJ$AB*ue&tw-A\u0003i_N$\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\u0006g\u0016tG/M\u000b\u0002\tB\u0019QIS\u001c\u000e\u0003\u0019S!a\u0012%\u0002\u0013%lW.\u001e;bE2,'BA%/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0017\u001a\u0013A\u0001T5ti\u000611/\u001a8uc\u0001\nQa]3oiJ\naa]3oiJ\u0002\u0013!B:fiV\u0003HC\u0001\u0017R\u0011\u0015\u0011V\u00021\u0001T\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001+^\u001b\u0005)&B\u0001,X\u0003\r\t\u0007/\u001b\u0006\u00031f\u000bqA[;qSR,'O\u0003\u0002[7\u0006)!.\u001e8ji*\tA,A\u0002pe\u001eL!AX+\u0003\u0011Q+7\u000f^%oM>D#!\u00041\u0011\u0005Q\u000b\u0017B\u00012V\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0012i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tG#\u0001\u0017)\u000591\u0007C\u0001+h\u0013\tAWK\u0001\u0003UKN$\u0018a\t;fgR\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f\u001d\u0015\u0003\u001f\u0019\f1\u0007^3ti\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b\u000fR;f)>\u001cuN\u001d:vaRdunZ:)\u0005A1\u0017A\t;fgR\u001cE.Z1o'\",H\u000fZ8x]^KG\u000f\u001b.l+:\fg/Y5mC\ndW\r\u000b\u0002\u0012M\u0006)c/\u001a:jMf\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f]\u000b\u0003cv$2A]A\u0010)\ta3\u000fC\u0003u%\u0001\u000fQ/A\tfq\u000e,\u0007\u000f^5p]\u000ec\u0017m]:UC\u001e\u00042A^=|\u001b\u00059(B\u0001=/\u0003\u001d\u0011XM\u001a7fGRL!A_<\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"\u0001`?\r\u0001\u0011)aP\u0005b\u0001\u007f\n\tQ)\u0005\u0003\u0002\u0002\u0005\u001d\u0001cA\u0017\u0002\u0004%\u0019\u0011Q\u0001\u0018\u0003\u000f9{G\u000f[5oOB!\u0011\u0011BA\r\u001d\u0011\tY!!\u0006\u000f\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u001d\u0003\u0019a$o\\8u}%\tq&C\u0002\u0002\u00189\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0005u!!C#yG\u0016\u0004H/[8o\u0015\r\t9B\f\u0005\u0006KI\u0001\raJ\u0001\u0017SNtuN\u001c#bK6|gnS1gW\u0006$\u0006N]3bIR!\u0011QEA\u0016!\ri\u0013qE\u0005\u0004\u0003Sq#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[\u0019\u0002\u0019AA\u0018\u0003\u0005!\bc\u0001\u001d\u00022%\u0019\u00111G\u001d\u0003\rQC'/Z1e\u0003q1XM]5gs:{g\u000eR1f[>tG\u000b\u001b:fC\u0012\u001c8\u000b^1ukN\fq\u0003^3ti\u000e{gn]3dkRLg/Z*ikR$wn\u001e8)\u0005U1\u0017\u0001\t;fgR\u001cuN\u001c;s_2dWM]*ikR$wn\u001e8EkJLgnZ*f]\u0012D#A\u00064)\u000f\u0001\t\t%a\u0012\u0002JA\u0019A+a\u0011\n\u0007\u0005\u0015SKA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003q\u0002")
public class ServerShutdownTest
extends QuorumTestHarness {
    private KafkaConfig config = null;
    private final String host;
    private final String topic;
    private final List<String> sent1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
    private final List<String> sent2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"more", "messages"}));

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testCleanShutdown() {
        Properties properties;
        Time time;
        KafkaConfig x$12 = this.config();
        Option x$22 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$32 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(x$12, x$32, x$22, bl);
        server.startup();
        ObjectRef producer = ObjectRef.create((Object)ServerShutdownTest.createProducer$1(server));
        KafkaZkClient x$5 = this.zkClient();
        String x$6 = this.topic();
        scala.collection.immutable.Seq x$7 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}));
        int n = 1;
        int n2 = 1;
        Properties properties2 = properties = new Properties();
        properties = null;
        Properties x$10 = properties2;
        TestUtils$.MODULE$.createTopic(x$5, x$6, n, n2, (Seq<KafkaServer>)x$7, x$10);
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        server.shutdown();
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        server = new KafkaServer(this.config(), Time.SYSTEM, (Option)None$.MODULE$, false);
        server.startup();
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), this.topic(), 0, 15000L);
        producer.elem = ServerShutdownTest.createProducer$1(server);
        KafkaConsumer consumer = ServerShutdownTest.createConsumer$1(server);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
        server.shutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        this.verifyCleanShutdownAfterFailedStartup(newConfig, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    @Test
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs() {
        Properties properties;
        Time time;
        KafkaConfig x$1 = this.config();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, bl);
        server.startup();
        KafkaZkClient x$5 = this.zkClient();
        String x$6 = this.topic();
        scala.collection.immutable.Seq x$7 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}));
        int n = 1;
        int n2 = 1;
        Properties properties2 = properties = new Properties();
        properties = null;
        Properties x$10 = properties2;
        TestUtils$.MODULE$.createTopic(x$5, x$6, n, n2, (Seq<KafkaServer>)x$7, x$10);
        server.shutdown();
        server.awaitShutdown();
        this.config().logDirs().foreach((Function1 & Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        this.verifyCleanShutdownAfterFailedStartup(this.config(), ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    @Test
    public void testCleanShutdownWithZkUnavailable() {
        Time time;
        KafkaConfig x$1 = this.config();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, bl);
        server.startup();
        this.shutdownZooKeeper();
        server.shutdown();
        server.awaitShutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(KafkaConfig config, ClassTag<E> exceptionClassTag) {
        Time time;
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(config, x$3, x$2, bl);
        try {
            try {
                server.startup();
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)server.brokerState());
            }
        }
        finally {
            BrokerState brokerState = server.brokerState();
            BrokerState brokerState2 = BrokerState.NOT_RUNNING;
            if (brokerState == null ? brokerState2 != null : !brokerState.equals(brokerState2)) {
                server.shutdown();
            }
            server.awaitShutdown();
        }
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$5 -> (Thread)x$5, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @Test
    public void testConsecutiveShutdown() {
        KafkaServer server = new KafkaServer(this.config(), Time.SYSTEM, (Option)None$.MODULE$, false);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        server.shutdown();
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$6 -> x$6.node(listenerName))).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private static final KafkaProducer createProducer$1(KafkaServer server) {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), SecurityProtocol.PLAINTEXT);
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        return TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl);
    }

    private static final KafkaConsumer createConsumer$1(KafkaServer server) {
        None$ none$;
        None$ none$2;
        String string;
        String string2;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), SecurityProtocol.PLAINTEXT);
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String string3 = string2 = "group";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$6 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$10 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$11 = none$4;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$10, (Option<Properties>)x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

