/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001i!)\u0011\t\u0001C\u0001\u0005\"9\u0001\u000bAI\u0001\n\u0003\tv!\u0002/\u000e\u0011\u0003if!\u0002\u0007\u000e\u0011\u0003q\u0006\"B\r\n\t\u0003y\u0006\"\u00021\n\t\u0003\t'!D(gMN,G/T1q)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005\u0019An\\4\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002'Q,7\u000f\u001e\"bg&\u001cg+\u00197jI\u0006$\u0018n\u001c8\u0015\u0003}\u0001\"\u0001\u0006\u0011\n\u0005\u0005*\"\u0001B+oSRD#AA\u0012\u0011\u0005\u0011jS\"A\u0013\u000b\u0005\u0019:\u0013aA1qS*\u0011\u0001&K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]\u0015\u0012A\u0001V3ti\u0006IA/Z:u\u00072,\u0017M\u001d\u0015\u0003\u0007\r\nq\u0002^3ti\u001e+Go\u00165f]\u001a+H\u000e\u001c\u0015\u0003\t\r\n1a[3z)\t)T\b\u0005\u00027w5\tqG\u0003\u00029s\u0005\u0019a.[8\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u001a\u0006\u0001\u0004q\u0004C\u0001\u000b@\u0013\t\u0001UC\u0001\u0003M_:<\u0017a\u0003<bY&$\u0017\r^3NCB$2a\u0011$L!\taB)\u0003\u0002F\u001b\ty1k[5naf|eMZ:fi6\u000b\u0007\u000fC\u0003H\r\u0001\u0007\u0001*A\u0003ji\u0016l7\u000f\u0005\u0002\u0015\u0013&\u0011!*\u0006\u0002\u0004\u0013:$\bb\u0002'\u0007!\u0003\u0005\r!T\u0001\u000bY>\fGMR1di>\u0014\bC\u0001\u000bO\u0013\tyUC\u0001\u0004E_V\u0014G.Z\u0001\u0016m\u0006d\u0017\u000eZ1uK6\u000b\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0011&FA'TW\u0005!\u0006CA+[\u001b\u00051&BA,Y\u0003%)hn\u00195fG.,GM\u0003\u0002Z+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m3&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006iqJ\u001a4tKRl\u0015\r\u001d+fgR\u0004\"\u0001H\u0005\u0014\u0005%\u0019B#A/\u0002\t5\f\u0017N\u001c\u000b\u0003?\tDQaY\u0006A\u0002\u0011\fA!\u0019:hgB\u0019A#Z4\n\u0005\u0019,\"!B!se\u0006L\bC\u00015p\u001d\tIW\u000e\u0005\u0002k+5\t1N\u0003\u0002m#\u00051AH]8pizJ!A\\\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]V\u0001")
public class OffsetMapTest {
    public static void main(String[] args) {
        OffsetMapTest$.MODULE$.main(args);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, "MD5");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, "MD5");
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assertions.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assertions.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(Long.toString(key).getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), "MD5");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

