/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.ProducerStateEntry;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004T\u0001\u0001\u0006I!\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0001M\u0011\u0019)\u0006\u0001)A\u0005\u001b\"9a\u000b\u0001b\u0001\n\u0003a\u0005BB,\u0001A\u0003%Q\nC\u0004Y\u0001\t\u0007I\u0011\u0001'\t\re\u0003\u0001\u0015!\u0003N\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u001a\u0001!\u0002\u0013a\u0006bB3\u0001\u0005\u0004%\ta\u0017\u0005\u0007M\u0002\u0001\u000b\u0011\u0002/\t\u000f\u001d\u0004!\u0019!C\u0001\u0019\"1\u0001\u000e\u0001Q\u0001\n5Cq!\u001b\u0001C\u0002\u0013\u0005!\u000eC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B6\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0005\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005E\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0005\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003g\u0002A\u0011AA5\u0011\u001d\ti\b\u0001C\u0001\u0003SBq!!!\u0001\t\u0003\tI\u0007C\u0004\u0002\u0006\u0002!\t!!\u001b\t\u000f\u0005%\u0005\u0001\"\u0001\u0002j!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAX\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003g\u0003A\u0011AA5\u0011\u001d\t9\f\u0001C\u0001\u0003SBq!a/\u0001\t\u0003\tI\u0007C\u0004\u0002@\u0002!\t!!\u001b\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002j!9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0004bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003G\u0004A\u0011AA5\u0011\u001d\t9\u000f\u0001C\u0001\u0003SBq!a;\u0001\t\u0003\tI\u0007C\u0004\u0002p\u0002!\t!!\u001b\t\u000f\u0005M\b\u0001\"\u0001\u0002j!9\u0011q\u001f\u0001\u0005\u0002\u0005%\u0004bBA~\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/AqA!\n\u0001\t\u0013\u00119\u0003C\u0005\u00036\u0001\t\n\u0011\"\u0003\u00038!I!Q\n\u0001\u0012\u0002\u0013%!q\n\u0005\n\u0005'\u0002\u0011\u0013!C\u0005\u0005+BqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003`\u0001!IA!\u0019\t\u0013\tu\u0004!%A\u0005\n\t}\u0004\"\u0003BB\u0001E\u0005I\u0011\u0002B@\u0011%\u0011)\tAI\u0001\n\u0013\u0011y\u0005C\u0005\u0003\b\u0002\t\n\u0011\"\u0003\u0003P\t\u0001BK]1og\u0006\u001cG/[8ogR+7\u000f\u001e\u0006\u0003yu\n1!\u00199j\u0015\u0005q\u0014!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\u001f\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\r\u000e\u0013acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0003\"A\u0013\u0001\u000e\u0003m\n!B\\;n'\u0016\u0014h/\u001a:t+\u0005i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%aA%oi\u0006Ya.^7TKJ4XM]:!\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA\u0005QBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0006YBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\nQD\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u001f]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\na\u0001^8qS\u000e\fT#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]:\u0016\u0003-\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003\u001diW\u000f^1cY\u0016T!\u0001](\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002s[\n1!)\u001e4gKJ\u0004b\u0001\u001e@\u0002\u0002\u0005\u0005Q\"A;\u000b\u0005Y<\u0018\u0001\u00039s_\u0012,8-\u001a:\u000b\u0005aL\u0018aB2mS\u0016tGo\u001d\u0006\u0003}iT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011q0\u001e\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b9\u000b\u0019!a\u0002\n\u0007\u0005\u0015qJA\u0003BeJ\f\u0017\u0010E\u0002O\u0003\u0013I1!a\u0003P\u0005\u0011\u0011\u0015\u0010^3\u0002/Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u0016\u0005\u0005M\u0001\u0003\u00027r\u0003+\u0001\u0002\"a\u0006\u0002\u001e\u0005\u0005\u0011\u0011A\u0007\u0003\u00033Q1!a\u0007x\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002BA\u0010\u00033\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018a\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:!\u0003eqwN\u001c+sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u000259|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!a\u000b\u0011\r\u00055\u0012qFA\u001a\u001b\u0005y\u0017bAA\u0019_\n\u00191+Z9\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f>\u0003\u0019\u0019XM\u001d<fe&!\u0011QHA\u001c\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000bM,G/\u00169\u0015\t\u0005\r\u0013\u0011\n\t\u0004\u001d\u0006\u0015\u0013bAA$\u001f\n!QK\\5u\u0011\u001d\tYe\u0006a\u0001\u0003\u001b\n\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u001f\nY&\u0004\u0002\u0002R)\u0019A(a\u0015\u000b\t\u0005U\u0013qK\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI\u0006`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003;\n\tF\u0001\u0005UKN$\u0018J\u001c4pQ\r9\u0012\u0011\r\t\u0005\u0003\u001f\n\u0019'\u0003\u0003\u0002f\u0005E#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u0006\u0002\u0002D!\u001a\u0001$!\u001c\u0011\t\u0005=\u0013qN\u0005\u0005\u0003c\n\tFA\u0005BMR,'/R1dQ\u0006)B/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\u001c\bfA\r\u0002xA!\u0011qJA=\u0013\u0011\tY(!\u0015\u0003\tQ+7\u000f^\u00013i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'o\u00155pk2$gj\u001c;TK\u0016,f\u000eZ3dS\u0012,G\rR1uC\"\u001a!$a\u001e\u0002UQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017J\\2mk\u0012,7/\u00112peR,G\r\u0016:b]N\f7\r^5p]\"\u001a1$a\u001e\u00025Q,7\u000f^*f]\u0012|eMZ:fiN<\u0016\u000e\u001e5He>,\b/\u00133)\u0007q\t9(\u0001\u0011uKN$8+\u001a8e\u001f\u001a47/\u001a;t/&$\bn\u0012:pkBlU\r^1eCR\f\u0007fA\u000f\u0002x\u0005Q1/\u001a8e\u001f\u001a47/\u001a;\u0015\t\u0005\r\u0013\u0011\u0013\u0005\b\u0003's\u0002\u0019AAK\u0003\u0019\u0019w.\\7jiBQa*a&t\u00037\u000b)\"a\u0011\n\u0007\u0005euJA\u0005Gk:\u001cG/[8ogA!\u0011QTAV\u001d\u0011\ty*a*\u0011\u0007\u0005\u0005v*\u0004\u0002\u0002$*\u0019\u0011QU \u0002\rq\u0012xn\u001c;?\u0013\r\tIkT\u0001\u0007!J,G-\u001a4\n\u0007\r\fiKC\u0002\u0002*>\u000b1\u0003^3ti\u001a+gnY5oO>s7i\\7nSRD3aHA<\u0003a!Xm\u001d;GK:\u001c\u0017N\\4P]N+g\u000eZ(gMN,Go\u001d\u0015\u0004A\u0005]\u0014\u0001\f;fgR|eMZ:fi6+G/\u00193bi\u0006LenU3oI>3gm]3ugR{GK]1og\u0006\u001cG/[8oQ\r\t\u0013qO\u0001\u001ci\u0016\u001cH/\u00138jiR\u0013\u0018M\\:bGRLwN\\:US6,w.\u001e;)\u0007\t\n9(A\u0012uKN$8+\u001a8e\u001f\u001a47/\u001a;t)>$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;)\u0007\r\n9(\u0001\u000fuKN$8i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;)\u0007\u0011\n9(A\u000euKN$\u0018IY8siR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004K\u0005]\u0014a\u0003;fgR$\u0016.\\3pkR$b!a\u0011\u0002P\u0006e\u0007bBAiM\u0001\u0007\u00111[\u0001\u0013]\u0016,G-\u00138ji\u0006sGmU3oI6\u001bx\rE\u0002O\u0003+L1!a6P\u0005\u001d\u0011un\u001c7fC:Dq!a7'\u0001\u0004\ti.\u0001\buS6,w.\u001e;Qe>\u001cWm]:\u0011\r9\u000byn]A\"\u0013\r\t\to\u0014\u0002\n\rVt7\r^5p]F\n\u0011\u0003^3ti\u001a+gnY5oO>s7+\u001a8eQ\r9\u0013qO\u0001\u001bi\u0016\u001cHOR3oG&twm\u00148BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004Q\u0005]\u0014A\t;fgR4UM\\2j]\u001e|e\u000e\u0016:b]N\f7\r^5p]\u0016C\b/\u001b:bi&|g\u000eK\u0002*\u0003o\nA\u0004^3ti6+H\u000e^5qY\u0016l\u0015M]6feN|e.\u001a'fC\u0012,'\u000fK\u0002+\u0003o\nA\u0005^3ti\u000e{gn]3dkRLg/\u001a7z%Vt\u0017J\\5u)J\fgn]1di&|gn\u001d\u0015\u0004W\u0005]\u0014A\u0007;fgR\u0014U/\u001c9Ue\u0006t7/Y2uS>t\u0017\r\\#q_\u000eD\u0007f\u0001\u0017\u0002x\u00059B/Z:u\r\u0006LG.\u001e:f)>4UM\\2f\u000bB|7\r\u001b\u0015\u0004[\u0005]\u0014aJ:f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY6+7o]1hKN<\u0016\u000e\u001e5WC2,XMU1oO\u0016$B\"a\u0011\u0003\u0004\t\u0015!\u0011\u0002B\u0007\u0005#AQA\u001e\u0018A\u0002MDqAa\u0002/\u0001\u0004\tY*A\u0003u_BL7\r\u0003\u0004\u0003\f9\u0002\r!T\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u0005\u001fq\u0003\u0019A'\u0002\u0007\u0015tG\rC\u0004\u0003\u00149\u0002\r!a5\u0002\u001f]LG\u000e\u001c\"f\u0007>lW.\u001b;uK\u0012\f1b]3sm\u0016\u0014\bK]8qgR\u0011!\u0011\u0004\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)\u0019!q\u00041\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005G\u0011iB\u0001\u0006Qe>\u0004XM\u001d;jKN\f1d\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0003CA\u000b\u0005S\u0011iC!\r\t\u0013\t-\u0002\u0007%AA\u0002\u0005m\u0015!B4s_V\u0004\b\u0002\u0003B\u0018aA\u0005\t\u0019A'\u0002\u001d5\f\u0007\u0010U8mYJ+7m\u001c:eg\"I!1\u0007\u0019\u0011\u0002\u0003\u0007!\u0011D\u0001\u0006aJ|\u0007o]\u0001&GJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIE*\"A!\u000f+\t\u0005m%1H\u0016\u0003\u0005{\u0001BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0005v]\u000eDWmY6fI*\u0019!qI(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003L\t\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005#R3!\u0014B\u001e\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003X)\"!\u0011\u0004B\u001e\u0003u\u0019'/Z1uKJ+\u0017\rZ+oG>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0003BA\u000b\u0005;BqAa\u000b5\u0001\u0004\tY*A\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u000b\fg\n\r$q\rB9\u0005k\u0012I\bC\u0004\u0003fU\u0002\r!a'\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012D\u0011B!\u001b6!\u0003\u0005\rAa\u001b\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t!\rq%QN\u0005\u0004\u0005_z%\u0001\u0002'p]\u001eD\u0011Ba\u001d6!\u0003\u0005\rAa\u001b\u0002\u00155\f\u0007P\u00117pG.l5\u000f\u0003\u0005\u0003xU\u0002\n\u00111\u0001N\u0003E!W\r\\5wKJLH+[7f_V$Xj\u001d\u0005\t\u0005w*\u0004\u0013!a\u0001\u001b\u0006\u0001\"/Z9vKN$H+[7f_V$Xj]\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uII*\"A!!+\t\t-$1H\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIM\nQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002K\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3sI\u0011,g-Y;mi\u0012*\u0004")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig, this.createTopic$default$5());
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig, this.createTopic$default$5());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable)x$2 -> this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable)x$3 -> this.createReadCommittedConsumer("transactional-group", 500, new Properties()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable)x$4 -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, 15000L);
        scala.collection.immutable.Set expectedValues = ((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3", "4"}))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, 15000L);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L).foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        String string;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String string2 = string = "group";
        string = null;
        String x$2 = string2;
        int n = 500;
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, n, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L);
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsetsWithGroupId() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @Test
    public void testSendOffsetsWithGroupMetadata() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), 15000L);
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").toString()).append(new StringBuilder(21).append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString()).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, 500, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"cannot read committed offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testInitTransactionsTimeout() {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", l, 3000L, n, n2);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @Test
    public void testSendOffsetsToTransactionTimeout() {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", l, 3000L, n, n2);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @Test
    public void testCommitTransactionTimeout() {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", l, 3000L, n, n2);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @Test
    public void testAbortTransactionTimeout() {
        Function1 & Serializable testTimeout_timeoutProcess = (Function1 & Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", l, 3000L, n, n2);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionProducer", l, 3000L, n, n2);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        producer.close(Duration.ZERO);
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)server.logManager().liveLogDirs().map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)server.logManager().liveLogDirs().map((Function1 & Serializable)x$10 -> x$10.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised a ProducerFencedException since the transaction has expired");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, 15000L);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava());
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig, this.createTopic$default$5());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWith10PartitionsAndOneReplica, topicWith10Partitions}))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, 15000L);
        scala.collection.immutable.Set expectedValues = package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable)x$11 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$11))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", 60000L, 60000L, 120000, 30000);
        producer.initTransactions();
        Assertions.assertThrows(KafkaException.class, () -> producer.initTransactions());
    }

    @Test
    public void testBumpTransactionalEpoch() {
        long l = 60000L;
        long l2 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", l, l2, 5000, 5000);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.servers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2(), testTopic}))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @Test
    public void testFailureToFenceEpoch() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        long l = 60000L;
        int n = 120000;
        int n2 = 30000;
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("transactional-producer", l, 1000L, n, n2);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.servers(), new TopicPartition(this.topic1(), 0), 15000L);
        LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        long l2 = 60000L;
        int n3 = 120000;
        int n4 = 30000;
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer("transactional-producer", l2, 5000L, n3, n4);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT);
        String string2 = string = "earliest";
        string = null;
        String x$6 = string2;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$7 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, false, true, maxPollRecords, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        void var2_17;
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT);
        String string2 = string = "earliest";
        string = null;
        String x$4 = string2;
        boolean bl = false;
        int n = 500;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$7 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, false, bl, n, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var2_17;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaServer> x$2 = this.servers();
        int n = 16384;
        int n2 = 5;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, n, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, n2);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$11) {
        return Integer.toString(x$11);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$8, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

