/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.Both$;
import kafka.api.EndToEndAuthorizationTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00044\u0001\u0001\u0006Ia\u000b\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019\u0001\u0005\u0001)A\u0005m!)\u0011\t\u0001C)\u0005\"9!\u000b\u0001b\u0001\n#\u001a\u0006B\u00020\u0001A\u0003%A\u000bC\u0004`\u0001\t\u0007I\u0011K*\t\r\u0001\u0004\u0001\u0015!\u0003U\u0011\u001d\t\u0007A1A\u0005B\tDaA\u001a\u0001!\u0002\u0013\u0019\u0007bB4\u0001\u0005\u0004%IA\u000b\u0005\u0007Q\u0002\u0001\u000b\u0011B\u0016\t\u000f%\u0004!\u0019!C!E\"1!\u000e\u0001Q\u0001\n\rDqa\u001b\u0001C\u0002\u0013%!\u0006\u0003\u0004m\u0001\u0001\u0006Ia\u000b\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019y\u0007\u0001)A\u00051\")\u0001\u000f\u0001C!c\")Q\u000f\u0001C!m\")q\u0010\u0001C!c\"1\u0011\u0011\u0001\u0001\u0005\u0002EDq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002.\u0001!I!a\f\u0003Q\u0011+G.Z4bi&|g\u000eV8lK:,e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u000b\u0005uq\u0012aA1qS*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012%\u001b\u0005a\u0012BA\u0013\u001d\u0005e)e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0012\u0001\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw-A\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0013!G6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N,\u0012A\u000e\t\u0004oyZS\"\u0001\u001d\u000b\u0005eR\u0014!C5n[V$\u0018M\u00197f\u0015\tYD(\u0001\u0006d_2dWm\u0019;j_:T\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fa\u0012A\u0001T5ti\u0006Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002\u0007B\u0011A\tU\u0007\u0002\u000b*\u0011aiR\u0001\u0005CV$\bN\u0003\u0002I\u0013\u0006A1/Z2ve&$\u0018P\u0003\u0002K\u0017\u000611m\\7n_:T!a\b'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#\u0016\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\u0005!\u0006cA+W16\tA(\u0003\u0002Xy\t!1k\\7f!\tIF,D\u0001[\u0015\tYv&\u0001\u0003vi&d\u0017BA/[\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013aD2mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\u0016\u0003\r\u0004\"\u0001\u00123\n\u0005\u0015,%AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u0011G2LWM\u001c;Qe&t7-\u001b9bY\u0002\nab\u00197jK:$\b+Y:to>\u0014H-A\bdY&,g\u000e\u001e)bgN<xN\u001d3!\u00039Y\u0017MZ6b!JLgnY5qC2\fqb[1gW\u0006\u0004&/\u001b8dSB\fG\u000eI\u0001\u000eW\u000647.\u0019)bgN<xN\u001d3\u0002\u001d-\fgm[1QCN\u001cxo\u001c:eA\u0005Y\u0002O]5wS2,w-\u001a3BI6Lgn\u00117jK:$8i\u001c8gS\u001e,\u0012\u0001W\u0001\u001daJLg/\u001b7fO\u0016$\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4!\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012A\u001d\t\u0003+NL!\u0001\u001e\u001f\u0003\tUs\u0017\u000e^\u0001\u001cGJ,\u0017\r^3Qe&4\u0018\u000e\\3hK\u0012\fE-\\5o\u00072LWM\u001c;\u0015\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u000b\u0005$W.\u001b8\u000b\u0005q\\\u0015aB2mS\u0016tGo]\u0005\u0003}f\u0014Q!\u00113nS:\f!eY8oM&<WO]3TK\u000e,(/\u001b;z\u0003\u001a$XM]*feZ,'o]*uCJ$\u0018!\t;fgR\u001c%/Z1uKV\u001bXM],ji\"$U\r\\3hCRLwN\u001c+pW\u0016t\u0007f\u0001\r\u0002\u0006A!\u0011qAA\n\u001b\t\tIAC\u0002\u001e\u0003\u0017QA!!\u0004\u0002\u0010\u00059!.\u001e9ji\u0016\u0014(bAA\t\u001d\u0006)!.\u001e8ji&!\u0011QCA\u0005\u0005\u0011!Vm\u001d;\u0002\u000bM,G/\u00169\u0015\u0007I\fY\u0002C\u0004\u0002\u001ee\u0001\r!a\b\u0002\u0011Q,7\u000f^%oM>\u0004B!a\u0002\u0002\"%!\u00111EA\u0005\u0005!!Vm\u001d;J]\u001a|\u0007fA\r\u0002(A!\u0011qAA\u0015\u0013\u0011\tY#!\u0003\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fde\u0016\fG/\u001a#fY\u0016<\u0017\r^5p]R{7.\u001a8t)\t\t\t\u0004E\u0004V\u0003g\t9$a\u000e\n\u0007\u0005UBH\u0001\u0004UkBdWM\r\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003)!W\r\\3hCRLwN\u001c\u0006\u0004\u0003\u0003:\u0015!\u0002;pW\u0016t\u0017\u0002BA#\u0003w\u0011q\u0002R3mK\u001e\fG/[8o)>\\WM\u001c")
public class DelegationTokenEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms = CollectionConverters$.MODULE$.CollectionHasAsScala(ScramMechanism.mechanismNames()).asScala().toList();
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    private final KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser());
    private final String clientPassword = JaasTestUtils$.MODULE$.KafkaScramPassword();
    private final KafkaPrincipal kafkaPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramAdmin());
    private final String kafkaPassword = JaasTestUtils$.MODULE$.KafkaScramAdminPassword();
    private final Properties privilegedAdminClientConfig = new Properties();

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    private String clientPassword() {
        return this.clientPassword;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    private String kafkaPassword() {
        return this.kafkaPassword;
    }

    private Properties privilegedAdminClientConfig() {
        return this.privilegedAdminClientConfig;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());
    }

    @Override
    public void configureSecurityAfterServersStart() {
        super.configureSecurityAfterServersStart();
        this.createScramCredentialsViaPrivilegedAdminClient(this.clientPrincipal().getName(), this.clientPassword());
        this.waitForUserScramCredentialToAppearOnAllBrokers(this.clientPrincipal().getName(), this.kafkaClientSaslMechanism());
        Tuple2<DelegationToken, DelegationToken> tokens = this.createDelegationTokens();
        DelegationToken token = (DelegationToken)tokens._1();
        DelegationToken privilegedToken = (DelegationToken)tokens._2();
        this.privilegedAdminClientConfig().putAll((Map<?, ?>)this.adminClientConfig());
        String clientLoginContext = JaasTestUtils$.MODULE$.tokenClientLoginModule(token.tokenInfo().tokenId(), token.hmacAsBase64String());
        this.producerConfig().put("sasl.jaas.config", clientLoginContext);
        this.consumerConfig().put("sasl.jaas.config", clientLoginContext);
        this.adminClientConfig().put("sasl.jaas.config", clientLoginContext);
        String privilegedClientLoginContext = JaasTestUtils$.MODULE$.tokenClientLoginModule(privilegedToken.tokenInfo().tokenId(), privilegedToken.hmacAsBase64String());
        this.privilegedAdminClientConfig().put("sasl.jaas.config", privilegedClientLoginContext);
    }

    @Test
    public void testCreateUserWithDelegationToken() {
        try (Admin privilegedAdminClient = Admin.create((Properties)this.privilegedAdminClientConfig());){
            String user = "user";
            AlterUserScramCredentialsResult results = privilegedAdminClient.alterUserScramCredentials(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UserScramCredentialAlteration[]{new UserScramCredentialUpsertion(user, new ScramCredentialInfo(org.apache.kafka.clients.admin.ScramMechanism.SCRAM_SHA_256, 4096), "password")}))).asJava());
            Assertions.assertEquals((int)1, (int)results.values().size());
            ((KafkaFuture)results.values().get(user)).get();
        }
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        super.setUp(testInfo);
        this.privilegedAdminClientConfig().put("bootstrap.servers", this.brokerList());
    }

    private Tuple2<DelegationToken, DelegationToken> createDelegationTokens() {
        Tuple2 tuple2;
        try (Admin adminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.clientPrincipal().getName(), this.clientPassword());
             Admin privilegedAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), this.kafkaPassword());){
            DelegationToken token = (DelegationToken)adminClient.createDelegationToken().delegationToken().get();
            DelegationToken privilegedToken = (DelegationToken)privilegedAdminClient.createDelegationToken().delegationToken().get();
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$1(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Timed out waiting for token to propagate to all servers");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            tuple2 = new Tuple2((Object)token, (Object)privilegedToken);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$2(KafkaServer server) {
        return server.tokenCache().tokens().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$createDelegationTokens$1(DelegationTokenEndToEndAuthorizationTest $this) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenEndToEndAuthorizationTest.$anonfun$createDelegationTokens$2(server)));
    }

    public static final /* synthetic */ String $anonfun$createDelegationTokens$3() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public DelegationTokenEndToEndAuthorizationTest() {
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), "testKey");
    }
}

