/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b!\u0002\u000f\u001e\u0003\u0003\u0011\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\t\u0011y\u0002!\u0011!Q\u0001\nEB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0003\")a\t\u0001C\u0001\u000f\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011\u0002'\t\r]\u0003\u0001\u0015!\u0003N\u0011\u001dA\u0006\u00011A\u0005\n\u0001Cq!\u0017\u0001A\u0002\u0013%!\f\u0003\u0004a\u0001\u0001\u0006K!\u0011\u0005\u0006K\u0002!\tA\u001a\u0005\u0006O\u0002!\t\u0001\u0011\u0005\u0006Q\u0002!\t\u0001\u0011\u0005\u0006S\u0002!\t\u0001\u0011\u0005\u0006U\u0002!\ta\u001b\u0005\u0006Y\u0002!\tA\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\u0006s\u0002!\tA\u001a\u0005\u0006u\u00021\tA\u001a\u0005\u0006w\u0002!\tE\u001a\u0005\u0006y\u0002!\t\u0001Q\u0004\b{v\t\t\u0011#\u0001\u007f\r\u001daR$!A\t\u0002}DaAR\r\u0005\u0002\u0005\u001d\u0001\"CA\u00053E\u0005I\u0011AA\u0006\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u000b\u0005yy\u0012!B;uS2\u001c(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aI\u0016\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t1A\u000b\u001b:fC\u0012\u0004\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003\u000f1{wmZ5oO\u0006!a.Y7f+\u0005\t\u0004C\u0001\u001a<\u001d\t\u0019\u0014\b\u0005\u00025o5\tQG\u0003\u00027C\u00051AH]8pizR\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!hN\u0001\u0006]\u0006lW\rI\u0001\u0010SNLe\u000e^3seV\u0004H/\u001b2mKV\t\u0011\t\u0005\u0002C\u00076\tq'\u0003\u0002Eo\t9!i\\8mK\u0006t\u0017\u0001E5t\u0013:$XM\u001d:vaRL'\r\\3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001*\u0013&\u0011\u00051\u0002\u0001\"B\u0018\u0006\u0001\u0004\t\u0004bB \u0006!\u0003\u0005\r!Q\u0001\u0012g\",H\u000fZ8x]&s\u0017\u000e^5bi\u0016$W#A'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016AC2p]\u000e,(O]3oi*\u0011!kJ\u0001\u0005kRLG.\u0003\u0002U\u001f\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017AE:ikR$wn\u001e8J]&$\u0018.\u0019;fI\u0002\n\u0001c\u001d5vi\u0012|wO\\\"p[BdW\r^3\u0002#MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0007%A\u0005jgN#\u0018M\u001d;fI\u0006i\u0011n]*uCJ$X\rZ0%KF$\"a\u00170\u0011\u0005\tc\u0016BA/8\u0005\u0011)f.\u001b;\t\u000f}[\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\u0015%\u001c8\u000b^1si\u0016$\u0007\u0005\u000b\u0002\rEB\u0011!iY\u0005\u0003I^\u0012\u0001B^8mCRLG.Z\u0001\tg\",H\u000fZ8x]R\t1,A\njgNCW\u000f\u001e3po:Le.\u001b;jCR,G-\u0001\njgNCW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0017AD5t)\"\u0014X-\u00193GC&dW\rZ\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\u0012!Q\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u000bA\fWo]3\u0015\u0007m{G\u000fC\u0003q'\u0001\u0007\u0011/A\u0004uS6,w.\u001e;\u0011\u0005\t\u0013\u0018BA:8\u0005\u0011auN\\4\t\u000bU\u001c\u0002\u0019\u0001<\u0002\tUt\u0017\u000e\u001e\t\u0003\u001d^L!\u0001_(\u0003\u0011QKW.Z+oSR\f\u0011\u0002[3beR\u0014W-\u0019;\u0002\r\u0011|wk\u001c:l\u0003\r\u0011XO\\\u0001\nSN\u0014VO\u001c8j]\u001e\f!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011A&G\n\u00043\u0005\u0005\u0001c\u0001\"\u0002\u0004%\u0019\u0011QA\u001c\u0003\r\u0005s\u0017PU3g)\u0005q\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u000e)\u001a\u0011)a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00078\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class ShutdownableThread
extends Thread
implements Logging {
    private final String name;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private volatile boolean isStarted;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return true;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public boolean isInterruptible() {
        return this.isInterruptible;
    }

    private CountDownLatch shutdownInitiated() {
        return this.shutdownInitiated;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private boolean isStarted() {
        return this.isStarted;
    }

    private void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownInitiated() {
        return this.shutdownInitiated().getCount() == 0L;
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete().getCount() == 0L;
    }

    public boolean isThreadFailed() {
        return this.isShutdownComplete() && !this.isShutdownInitiated();
    }

    public synchronized boolean initiateShutdown() {
        if (this.isRunning()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down");
            this.shutdownInitiated().countDown();
            if (this.isInterruptible()) {
                this.interrupt();
            }
            return true;
        }
        return false;
    }

    public void awaitShutdown() {
        if (!this.isShutdownInitiated()) {
            throw new IllegalStateException("initiateShutdown() was not called before awaitShutdown()");
        }
        if (this.isStarted()) {
            this.shutdownComplete().await();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) {
        if (this.shutdownInitiated().await(timeout, unit)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public void heartbeat() {
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.isStarted_$eq(true);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting");
        try {
            try {
                while (this.isRunning()) {
                    this.heartbeat();
                    this.doWork();
                }
            }
            catch (FatalExitError e) {
                this.shutdownInitiated().countDown();
                this.shutdownComplete().countDown();
                this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped");
                throw Exit$.MODULE$.exit(e.statusCode(), (Option<String>)None$.MODULE$);
            }
            catch (Throwable e) {
                if (this.isRunning()) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error due to", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.shutdownComplete().countDown();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped");
    }

    public boolean isRunning() {
        return !this.isShutdownInitiated();
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this.name = name;
        this.isInterruptible = isInterruptible;
        super(name);
        this.setDaemon(false);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(name).append("]: ").toString());
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
        this.isStarted = false;
    }
}

