/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreMetrics;
import kafka.tier.store.TierObjectStoreResponse;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class TierObjectStoreMetricsEnabled
implements TierObjectStore {
    private TierObjectStore inner;
    private TierObjectStoreMetrics tierObjectStoreMetrics;
    private Time time;

    public TierObjectStoreMetricsEnabled(TierObjectStore inner, Metrics metrics, Time time) {
        this.inner = inner;
        this.tierObjectStoreMetrics = new TierObjectStoreMetrics(metrics);
        this.time = time;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return this.inner.getBackend();
    }

    @Override
    public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffset, Integer byteOffsetEnd) throws IOException {
        switch (objectFileType) {
            case SEGMENT: {
                this.tierObjectStoreMetrics.segmentFetched().record();
                break;
            }
            case OFFSET_INDEX: {
                this.tierObjectStoreMetrics.offsetIndexFetched().record();
                break;
            }
            case TIMESTAMP_INDEX: {
                this.tierObjectStoreMetrics.timestampIndexFetched().record();
                break;
            }
            case TRANSACTION_INDEX: {
                this.tierObjectStoreMetrics.transactionIndexFetched().record();
                break;
            }
            case PRODUCER_STATE: {
                this.tierObjectStoreMetrics.producerStateFetched().record();
                break;
            }
            case EPOCH_STATE: {
                this.tierObjectStoreMetrics.epochStateFetched().record();
                break;
            }
            case TIER_STATE_SNAPSHOT: {
                this.tierObjectStoreMetrics.tierStateFetched().record();
            }
        }
        return this.inner.getObject(objectMetadata, objectFileType, byteOffset, byteOffsetEnd);
    }

    @Override
    public TierObjectStore.OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
        return this.inner.prepPutSegment();
    }

    @Override
    public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) throws TierObjectStoreRetriableException, IOException {
        this.inner.putObject(objectMetadata, file, fileType);
    }

    @Override
    public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws TierObjectStoreRetriableException, IOException {
        long startTime = this.time.milliseconds();
        this.inner.putSegment(objectMetadata, segmentData, offsetIndexData, timestampIndexData, producerStateSnapshotData, transactionIndexData, epochState);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.putLatency().record((double)(endTime - startTime));
    }

    @Override
    public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) throws IOException {
        long startTime = this.time.milliseconds();
        this.inner.deleteSegment(objectMetadata);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.deleteLatency().record((double)(endTime - startTime));
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

