/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.IOException;
import java.util.Optional;
import kafka.log.TierLogSegment;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.common.errors.KafkaStorageException;

public class TierUtils {
    private static Optional<MetadataWithOffset> metadataForOffset(TierPartitionState partitionState, long offset) throws KafkaStorageException {
        try {
            return partitionState.metadata(offset).map(tierLogSegment -> new MetadataWithOffset(offset, (TierLogSegment)tierLogSegment));
        }
        catch (IOException e) {
            throw new KafkaStorageException((Throwable)e);
        }
    }

    public static Optional<TierLogSegment> tierLogSegmentForOffset(TierPartitionState partitionState, long offset) {
        return TierUtils.metadataForOffset(partitionState, offset).map(v -> v.tierLogSegment);
    }

    private static class MetadataWithOffset {
        long startOffset;
        TierLogSegment tierLogSegment;

        MetadataWithOffset(long startOffset, TierLogSegment tierLogSegment) {
            this.startOffset = startOffset;
            this.tierLogSegment = tierLogSegment;
        }
    }
}

