/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.HashMap;
import java.util.Map;

public enum TierPartitionStatus {
    UNINITIALIZED(0),
    INIT(1),
    CATCHUP(2),
    ONLINE(3),
    DISK_OFFLINE(4),
    ERROR(5),
    READ_ONLY(6),
    FROZEN_LOG_START_OFFSET(7);

    final byte value;
    private static final Map<Byte, TierPartitionStatus> VALUE_TO_STATUS;

    private TierPartitionStatus(byte value) {
        this.value = value;
    }

    public boolean isOpen() {
        return this == INIT || this == CATCHUP || this == ONLINE || this == ERROR || this == READ_ONLY || this == FROZEN_LOG_START_OFFSET;
    }

    public boolean isOpenForWrite() {
        return this == INIT || this == CATCHUP || this == ONLINE;
    }

    public boolean hasError() {
        return this == ERROR || this == FROZEN_LOG_START_OFFSET;
    }

    public static byte toByte(TierPartitionStatus status) {
        return status.value;
    }

    public static TierPartitionStatus fromByte(byte value) {
        TierPartitionStatus status = VALUE_TO_STATUS.get(value);
        if (status == null) {
            throw new IllegalArgumentException("Unknown TierPartitionStatus byte value " + value);
        }
        return status;
    }

    static {
        VALUE_TO_STATUS = new HashMap<Byte, TierPartitionStatus>();
        for (TierPartitionStatus status : TierPartitionStatus.values()) {
            TierPartitionStatus oldStatus = VALUE_TO_STATUS.put(status.value, status);
            if (oldStatus == null) continue;
            throw new ExceptionInInitializerError("value reused for VALUE_TO_STATUS " + (Object)((Object)oldStatus) + " and " + (Object)((Object)status));
        }
    }
}

