/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.errors.KafkaStorageException;

public class FileTierPartitionStateUtils {
    private static final int ENTRY_LENGTH_SIZE = 2;

    public static TierObjectMetadata read(TopicIdPartition topicIdPartition, CheckedFileIO channel, long position) throws KafkaStorageException {
        try {
            ByteBuffer lengthBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            long currentPosition = position;
            long endPosition = channel.size();
            if (currentPosition + 2L > endPosition) {
                throw new KafkaStorageException("Unable to read TierObjectMetadata entry at position " + position + " with channel size " + endPosition);
            }
            channel.read(lengthBuffer, position);
            if (lengthBuffer.hasRemaining()) {
                throw new KafkaStorageException("Unable to read TierObjectMetadata entry at position " + position + " with channel size " + endPosition);
            }
            lengthBuffer.flip();
            short length = lengthBuffer.getShort();
            if ((currentPosition += (long)lengthBuffer.limit()) + (long)length > endPosition) {
                throw new KafkaStorageException("Unable to read TierObjectMetadata entry at position " + position + " with channel size " + endPosition);
            }
            ByteBuffer entryBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(entryBuffer, currentPosition);
            if (entryBuffer.hasRemaining()) {
                throw new KafkaStorageException("Unable to read TierObjectMetadata entry at position " + position + " with channel size " + endPosition);
            }
            entryBuffer.flip();
            return new TierObjectMetadata(topicIdPartition, TierPartitionStateEntry.getRootAsTierPartitionStateEntry(entryBuffer));
        }
        catch (IOException e) {
            throw new KafkaStorageException("Encountered error during iteration at byte offset " + position, (Throwable)e);
        }
    }
}

