/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kafka.log.AbortedTxn;
import kafka.tier.fetcher.AbstractInputStreamFixedSizeIterator;
import kafka.tier.fetcher.CancellationContext;

public class TierAbortedTxnReader {
    public static List<AbortedTxn> readInto(CancellationContext ctx, InputStream inputStream, long startOffset, long lastOffset) {
        ArrayList<AbortedTxn> abortedTxns = new ArrayList<AbortedTxn>();
        AbortedTxnsIterator abortedTxnsIterator = new AbortedTxnsIterator(inputStream);
        Iterable iter = () -> abortedTxnsIterator;
        for (AbortedTxn abortedTxn : iter) {
            if (ctx.isCancelled()) {
                throw new CancellationException("CancellationContext cancelled during read of aborted transaction indices");
            }
            if (!TierAbortedTxnReader.abortedTxnInRange(startOffset, lastOffset, abortedTxn)) continue;
            abortedTxns.add(abortedTxn);
        }
        return abortedTxns;
    }

    static boolean abortedTxnInRange(long fetchStartOffset, long fetchLastOffset, AbortedTxn abortedTxn) {
        long abortedTxnFirstOffset = abortedTxn.firstOffset();
        long abortedTxnLastOffset = abortedTxn.lastOffset();
        return fetchStartOffset <= abortedTxnLastOffset && abortedTxnFirstOffset <= fetchLastOffset;
    }

    private static class AbortedTxnsIterator
    extends AbstractInputStreamFixedSizeIterator<AbortedTxn> {
        AbortedTxnsIterator(InputStream inputStream) {
            super(inputStream, AbortedTxn.TotalSize());
        }

        @Override
        AbortedTxn toIndexEntry() {
            ByteBuffer buf = ByteBuffer.wrap((byte[])this.indexEntryBytes.clone());
            return new AbortedTxn(buf);
        }
    }
}

