/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class TierTopicProducerSupplier
implements Supplier<Producer<byte[], byte[]>> {
    private static final String CLIENT_TYPE = "producer";
    private static final String SEPARATOR = "-";
    private final TierTopicManagerConfig config;
    private final AtomicInteger instanceId = new AtomicInteger(0);

    public TierTopicProducerSupplier(TierTopicManagerConfig config) {
        this.config = config;
    }

    @Override
    public Producer<byte[], byte[]> get() {
        String clientId = TierTopicProducerSupplier.clientId(this.config.clusterId, this.config.brokerId, this.instanceId.getAndIncrement());
        return new KafkaProducer(TierTopicProducerSupplier.properties(this.config, clientId));
    }

    public static String clientId(String clusterId, int brokerId, long instanceId) {
        return TierTopicClient.clientIdPrefix(CLIENT_TYPE) + SEPARATOR + clusterId + SEPARATOR + brokerId + SEPARATOR + instanceId;
    }

    public static void addBaseProperties(Properties properties, String clientId, Integer requestTimeoutMs) {
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("acks", "all");
        properties.put("retries", Integer.toString(Integer.MAX_VALUE));
        properties.put("retry.backoff.ms", Integer.toString(2000));
        properties.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        properties.put("client.id", clientId);
        properties.put("request.timeout.ms", requestTimeoutMs);
        properties.put("enable.idempotence", "false");
        properties.put("max.in.flight.requests.per.connection", (Object)1);
    }

    public static Properties properties(TierTopicManagerConfig config, String clientId) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> configEntry : config.interBrokerClientConfigs.get().entrySet()) {
            properties.put(configEntry.getKey(), configEntry.getValue());
        }
        TierTopicProducerSupplier.addBaseProperties(properties, clientId, config.requestTimeoutMs);
        properties.remove("metric.reporters");
        return properties;
    }
}

