/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.log.AbstractLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerReconfigurable;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.HostedPartition$Offline$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tuh\u0001B\u001f?\u0001\rC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011!y\u0007A!A!\u0002\u0013\u0001\b\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0013}\u0004!\u0011!Q\u0001\n\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"a\u0013\u0001A\u0003%\u00111\u0007\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u001fB\u0001\"a\u0016\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u00033\u0002!\u0019!C\u0005\u00037B\u0001\"a\u001a\u0001A\u0003%\u0011Q\f\u0005\f\u0003S\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0007C\u0006\u0002t\u0001\u0001\r\u00111A\u0005\n\u0005U\u0004bCAA\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[B\u0011\"a!\u0001\u0001\u0004%I!!\"\t\u0013\u0005\u001d\u0005\u00011A\u0005\n\u0005%\u0005bBAG\u0001\u0001\u0006K\u0001\u001c\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#C\u0011\"a%\u0001\u0001\u0004%I!!&\t\u000f\u0005e\u0005\u0001)Q\u0005a\"Q\u00111\u0014\u0001C\u0002\u0013\u0005a(!(\t\u0011\u0005U\u0006\u0001)A\u0005\u0003?C1\"a.\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:\"Y\u0011Q\u001d\u0001A\u0002\u0003\u0007I\u0011BAt\u0011-\ti\r\u0001a\u0001\u0002\u0003\u0006K!a/\t\u0013\u0005M\b\u00011A\u0005\n\u0005U\b\"CA\u007f\u0001\u0001\u0007I\u0011BA\u0000\u0011!\u0011\u0019\u0001\u0001Q!\n\u0005]\bb\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u0011\t\u0003\u0001C!\u0005GAqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B\"\u0001\u0011\u0005!Q\u0006\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011%\u0011i\u0005AI\u0001\n\u0013\u0011y\u0005C\u0004\u0003f\u0001!IA!\f\t\u0011\t\u001d\u0004\u0001\"\u0001?\u0005[A\u0001B!\u001b\u0001\t\u0003q$Q\u0006\u0005\b\u0005W\u0002A\u0011\u0002B\u0017\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005[A\u0001Ba\u001c\u0001\t\u0003q$\u0011\u000f\u0005\t\u00053\u0003A\u0011\u0001 \u0003.!A!1\u0014\u0001\u0005\u0002y\u0012i\u0003\u0003\u0005\u0003\u001e\u0002!\tA\u0010BP\u0011!\u0011\t\f\u0001C\u0001}\tM\u0006\u0002\u0003B\u0011\u0001\u0011\u0005aH!/\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!\u0011\u001a\u0001\u0005\n\t-\u0007b\u0002Bl\u0001\u0011%!\u0011\\\u0004\b\u0005Kt\u0004\u0012\u0001Bt\r\u0019id\b#\u0001\u0003j\"9\u0011\u0011D\u001d\u0005\u0002\t-\b\"\u0003Bws\t\u0007I\u0011\u0001Bx\u0011!\u0011Y0\u000fQ\u0001\n\tE(\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_JT!a\u0010!\u0002\tQLWM\u001d\u0006\u0002\u0003\u0006)1.\u00194lC\u000e\u00011#\u0002\u0001E\u0015B3\u0006CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g\r\u0005\u0002L\u001d6\tAJ\u0003\u0002N\u0001\u0006)Q\u000f^5mg&\u0011q\n\u0014\u0002\b\u0019><w-\u001b8h!\t\tF+D\u0001S\u0015\t\u0019\u0006)A\u0004nKR\u0014\u0018nY:\n\u0005U\u0013&!E&bM.\fW*\u001a;sS\u000e\u001cxI]8vaB\u0011qKW\u0007\u00021*\u0011\u0011\fQ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mC&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-A\u0005tG\",G-\u001e7feB\u00111JX\u0005\u0003?2\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011qKY\u0005\u0003Gb\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\tuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b \u0002\u000bQ|\u0007/[2\n\u0005)<'!\u0005+jKJ$v\u000e]5d\u0007>t7/^7fe\u0006\t\u0012N\\5uS\u0006d\u0017J\u001c;feZ\fG.T:\u0011\u0005\u0015k\u0017B\u00018G\u0005\u0011auN\\4\u0002=%t\u0017\u000e^5bY6\u000b\u00070\u00138qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\bCA#r\u0013\t\u0011hIA\u0002J]R\fQ\u0002^5fe:\u000bW.Z:qC\u000e,\u0007CA;}\u001d\t1(\u0010\u0005\u0002x\r6\t\u0001P\u0003\u0002z\u0005\u00061AH]8pizJ!a\u001f$\u0002\rA\u0013X\rZ3g\u0013\tihP\u0001\u0004TiJLgn\u001a\u0006\u0003w\u001a\u000bA\u0001^5nKB!\u00111AA\u000b\u001b\t\t)AC\u0002N\u0003\u000fQA!!\u0003\u0002\f\u000511m\\7n_:T1!QA\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019\"A\u0002pe\u001eLA!a\u0006\u0002\u0006\t!A+[7f\u0003\u0019a\u0014N\\5u}Q\u0001\u0012QDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0012Q\u0006\t\u0004\u0003?\u0001Q\"\u0001 \t\u000bqC\u0001\u0019A/\t\u000b\u0001D\u0001\u0019A1\t\u000b\u0011D\u0001\u0019A3\t\u000b-D\u0001\u0019\u00017\t\u000b=D\u0001\u0019\u00019\t\u000bMD\u0001\u0019\u0001;\t\r}D\u0001\u0019AA\u0001\u0003=a\u0017m\u001d;IK\u0006\u0014HOY3bi6\u001bXCAA\u001a!\u0011\t)$a\u0012\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\ta!\u0019;p[&\u001c'\u0002BA\u001f\u0003\u007f\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\t%a\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\nAA[1wC&!\u0011\u0011JA\u001c\u0005)\tEo\\7jG2{gnZ\u0001\u0011Y\u0006\u001cH\u000fS3beR\u0014W-\u0019;Ng\u0002\nA\"[:J]^{'o\u001b'p_B,\"!!\u0015\u0011\t\u0005U\u00121K\u0005\u0005\u0003+\n9DA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eSNLenV8sW2{w\u000e\u001d\u0011\u0002\u001bQLWM\u001d+pa&\u001cg*Y7f+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\u0011\t\u0019'a\u0011\u0002\t1\fgnZ\u0005\u0004{\u0006\u0005\u0014A\u0004;jKJ$v\u000e]5d\u001d\u0006lW\rI\u0001\tY&\u001cH/\u001a8feV\u0011\u0011Q\u000e\t\u0005\u0003?\ty'C\u0002\u0002ry\u0012q\u0004R3mKR,G\rU1si&$\u0018n\u001c8t\u0007\"\fgnZ3MSN$XM\\3s\u00031a\u0017n\u001d;f]\u0016\u0014x\fJ3r)\u0011\t9(! \u0011\u0007\u0015\u000bI(C\u0002\u0002|\u0019\u0013A!\u00168ji\"I\u0011q\u0010\t\u0002\u0002\u0003\u0007\u0011QN\u0001\u0004q\u0012\n\u0014!\u00037jgR,g.\u001a:!\u0003ma\u0017m\u001d;EK2,G/\u001a3QCJ$\u0018\u000e^5p]\u000eCWmY6NgV\tA.A\u0010mCN$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\\"iK\u000e\\Wj]0%KF$B!a\u001e\u0002\f\"A\u0011qP\n\u0002\u0002\u0003\u0007A.\u0001\u000fmCN$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\\"iK\u000e\\Wj\u001d\u0011\u0002\u001b9,X.\u00138Qe><'/Z:t+\u0005\u0001\u0018!\u00058v[&s\u0007K]8he\u0016\u001c8o\u0018\u0013fcR!\u0011qOAL\u0011!\tyHFA\u0001\u0002\u0004\u0001\u0018A\u00048v[&s\u0007K]8he\u0016\u001c8\u000fI\u0001\u0015S6l\u0017n\u001a:bi\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005}\u0005cBAQ\u0003W\u0003\u0018qV\u0007\u0003\u0003GSA!!*\u0002(\u00069Q.\u001e;bE2,'bAAU\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00161\u0015\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0010\u0003cK1!a-?\u0005qIU.\\5he\u0006$X\r\u001a+jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#[7nS\u001e\u0014\u0018\r^3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\bd_>\u0014H-\u001b8bi>\u0014H+Y:l+\t\tY\f\r\u0003\u0002>\u0006%\u0007CBA`\u0003\u0003\f)-\u0004\u0002\u0002<%!\u00111YA\u001e\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BAd\u0003\u0013d\u0001\u0001B\u0006\u0002Lr\t\t\u0011!A\u0003\u0002\u0005]'aA0%c\u0005\u00012m\\8sI&t\u0017\r^8s)\u0006\u001c8\u000e\t\u0015\u00049\u0005E\u0007cA#\u0002T&\u0019\u0011Q\u001b$\u0003\u0011Y|G.\u0019;jY\u0016\fB!!7\u0002`B\u0019Q)a7\n\u0007\u0005ugIA\u0004O_RD\u0017N\\4\u0011\u0007\u0015\u000b\t/C\u0002\u0002d\u001a\u00131!\u00118z\u0003M\u0019wn\u001c:eS:\fGo\u001c:UCN\\w\fJ3r)\u0011\t9(!;\t\u0013\u0005}4$!AA\u0002\u0005-\b\u0007BAw\u0003c\u0004b!a0\u0002B\u0006=\b\u0003BAd\u0003c$A\"a3\u0002j\u0006\u0005\t\u0011!B\u0001\u0003/\faaY8oM&<WCAA|!\u0011\ty\"!?\n\u0007\u0005mhH\u0001\u0004D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA<\u0005\u0003A\u0011\"a \u001f\u0003\u0003\u0005\r!a>\u0002\u000f\r|gNZ5hA!\u001aq$!5\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!1\u0002\t\u0006\u0005\u001b\u0011y\u0001^\u0007\u0003\u0003OKAA!\u0005\u0002(\n\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA<\u0005/AqA!\u0007\"\u0001\u0004\u0011Y\"A\u0005oK^\u001cuN\u001c4jOB\u0019qK!\b\n\u0007\t}\u0001LA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$b!a\u001e\u0003&\t%\u0002b\u0002B\u0014E\u0001\u0007!1D\u0001\n_2$7i\u001c8gS\u001eDqA!\u0007#\u0001\u0004\u0011Y\"A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005]\u0014!\u00055b]\u0012dW-S7nS\u001e\u0014\u0018\r^5p]R!\u0011q\u000fB\u001a\u0011\u0019\u0011)\u0004\na\u0001a\u0006!B/[3s)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012\f\u0001\u0003[1oI2,W)\\5he\u0006$\u0018n\u001c8\u0015\t\u0005]$1\b\u0005\u0007\u0005k)\u0003\u0019\u00019\u0002!I,w-[:uKJd\u0015n\u001d;f]\u0016\u0014H\u0003BA<\u0005\u0003Bq!!\u001b'\u0001\u0004\ti'\u0001\u0005tQV$Hm\\<o\u0003A\u0019H/\u0019:u\u0007>|'\u000fZ5oCR|'\u000f\u0006\u0003\u0002x\t%\u0003\u0002\u0003B&QA\u0005\t\u0019\u00019\u0002\u000b\u0011,G.Y=\u00025M$\u0018M\u001d;D_>\u0014H-\u001b8bi>\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE#f\u00019\u0003T-\u0012!Q\u000b\t\u0005\u0005/\u0012\t'\u0004\u0002\u0003Z)!!1\fB/\u0003%)hn\u00195fG.,GMC\u0002\u0003`\u0019\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019G!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bti>\u00048i\\8sI&t\u0017\r^8s\u0003%AW-\u0019:uE\u0016\fG/\u0001\u0004e_^{'o[\u0001\u0016M&tG\rR3mKR,G\rU1si&$\u0018n\u001c8t\u0003=i\u0017m[3Ue\u0006t7/\u001b;j_:\u001c\u0018\u0001G2pY2,7\r\u001e#fY\u0016$X\r\u001a)beRLG/[8ogRA!1\u000fBC\u0005#\u0013)\n\u0005\u0004F\u0005kb'\u0011P\u0005\u0004\u0005o2%A\u0002+va2,'\u0007\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\u0011\u0011y(a\u0011\u0002\u00079Lw.\u0003\u0003\u0003\u0004\nu$A\u0003\"zi\u0016\u0014UO\u001a4fe\"9!qQ\u0018A\u0002\t%\u0015A\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BAa#\u0003\u000e6\u0011\u0011qA\u0005\u0005\u0005\u001f\u000b9A\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\tMu\u00061\u0001m\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t]u\u00061\u0001\u0003z\u0005y\u0011\r\u001c7pG\u0006$X\r\u001a\"vM\u001a,'/A\rnCf\u0014WMQ3hS:l\u0015\r^3sS\u0006d\u0017N_1uS>t\u0017AE7bs\n,')Z4j]\u0012+G.\u001a;j_:\fA\u0004\u001e:bG.Le.\u001b;jCR,\u0007+\u0019:uSRLwN\u001c#fY\u0016$X\r\u0006\u0005\u0002x\t\u0005&1\u0015BW\u0011\u0019\u0011)D\ra\u0001a\"9!Q\u0015\u001aA\u0002\t\u001d\u0016\u0001\u00053fY\u0016$X\r\u001a)beRLG/[8o!\u0011\tyB!+\n\u0007\t-fH\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"1!q\u0016\u001aA\u00021\faa\u001c4gg\u0016$\u0018\u0001\b;sC\u000e\\7i\\7qY\u0016$X\rU1si&$\u0018n\u001c8EK2,G/\u001a\u000b\u0007\u0003o\u0012)La.\t\r\tU2\u00071\u0001q\u0011\u001d\u0011)k\ra\u0001\u0005O#B!a\u001e\u0003<\"9!Q\u0018\u001bA\u0002\u0005]\u0018A\u00049s_B|7/\u001a3D_:4\u0017nZ\u0001\u0012kB$\u0017\r^3Ti\u0006\u0014Ho\u00144gg\u0016$HCBA<\u0005\u0007\u0014)\r\u0003\u0004\u00036U\u0002\r\u0001\u001d\u0005\u0007\u0005\u000f,\u0004\u0019\u00017\u0002\u001d9,wo\u0015;beR|eMZ:fi\u0006yB/[3s)>\u0004\u0018n\u0019)beRLG/[8og^KG\u000f\u001b)pg&$\u0018n\u001c8\u0016\u0005\t5\u0007cB;\u0003P\n%%\u0011[\u0005\u0004\u0003[s\b\u0003B#\u0003T2L1A!6G\u0005\u0019y\u0005\u000f^5p]\u0006\u00012-\u00198dK2Le\u000e\u0015:pOJ,7o\u001d\u000b\u0005\u0003o\u0012Y\u000eC\u0004\u0003^^\u0002\rAa8\u0002%%t\u0007K]8he\u0016\u001c8\u000fR3mKRLwN\u001c\t\u0005\u0003?\u0011\t/C\u0002\u0003dz\u0012!#\u00138Qe><'/Z:t\t\u0016dW\r^5p]\u0006\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s!\r\ty\"O\n\u0003s\u0011#\"Aa:\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!\u0011\u001f\t\u0007\u0005g\u0014I0!\u0018\u000e\u0005\tU(\u0002\u0002B|\u0003O\u000b\u0011\"[7nkR\f'\r\\3\n\t\tE!Q_\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0001")
public class TierDeletedPartitionsCoordinator
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TierTopicConsumer tierTopicConsumer;
    public final Time kafka$tier$TierDeletedPartitionsCoordinator$$time;
    private final AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    private final AtomicBoolean isInWorkLoop;
    private final String tierTopicName;
    private DeletedPartitionsChangeListener listener;
    private long lastDeletedPartitionCheckMs;
    private int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    private final scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions;
    private volatile ScheduledFuture<?> coordinatorTask;
    private volatile Config config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    }

    private AtomicBoolean isInWorkLoop() {
        return this.isInWorkLoop;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private DeletedPartitionsChangeListener listener() {
        return this.listener;
    }

    private void listener_$eq(DeletedPartitionsChangeListener x$1) {
        this.listener = x$1;
    }

    private long lastDeletedPartitionCheckMs() {
        return this.lastDeletedPartitionCheckMs;
    }

    private void lastDeletedPartitionCheckMs_$eq(long x$1) {
        this.lastDeletedPartitionCheckMs = x$1;
    }

    public int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    }

    private void kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(int x$1) {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = x$1;
    }

    public scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions() {
        return this.immigratedPartitions;
    }

    private ScheduledFuture<?> coordinatorTask() {
        return this.coordinatorTask;
    }

    private void coordinatorTask_$eq(ScheduledFuture<?> x$1) {
        this.coordinatorTask = x$1;
    }

    private Config config() {
        return this.config;
    }

    private void config_$eq(Config x$1) {
        this.config = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Config proposedConfigs = new Config(Predef$.MODULE$.Long2long(newConfig.tierTopicDeleteCheckIntervalMs()), Predef$.MODULE$.Integer2int(newConfig.tierTopicDeleteMaxInprogressPartitions()));
        this.reconfigure(proposedConfigs);
    }

    public void startup() {
        this.startCoordinator(100);
    }

    public void handleImmigration(int tierTopicPartitionId) {
        synchronized (this) {
            scala.collection.mutable.Map cfr_ignored_0 = (scala.collection.mutable.Map)this.immigratedPartitions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)), (Object)new ImmigratedTierTopicPartition()));
            return;
        }
    }

    public synchronized void handleEmigration(int tierTopicPartitionId) {
        this.immigratedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable)emigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1(this, emigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void registerListener(DeletedPartitionsChangeListener listener) {
        this.listener_$eq(listener);
    }

    public void shutdown() {
        this.stopCoordinator();
        this.removeMetrics$1();
    }

    private void startCoordinator(int delay) {
        if (this.coordinatorTask() != null) {
            throw new IllegalStateException("Attempt to start a duplicate coordinator");
        }
        this.coordinatorTask_$eq(this.scheduler.schedule("tier-deleted-partition-task", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.doWork(), delay, Math.min(60000L, this.config().intervalMs()), TimeUnit.MILLISECONDS));
    }

    private int startCoordinator$default$1() {
        return 0;
    }

    private void stopCoordinator() {
        if (this.coordinatorTask() != null) {
            this.coordinatorTask().cancel(false);
            this.coordinatorTask_$eq(null);
        }
    }

    public void heartbeat() {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().set(this.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds());
    }

    public void doWork() {
        block8: {
            block7: {
                try {
                    try {
                        if (!this.isInWorkLoop().compareAndSet(false, true)) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> "Work loop is already running; backing off");
                            break block7;
                        }
                        this.heartbeat();
                        long now = this.kafka$tier$TierDeletedPartitionsCoordinator$$time.hiResClockMs();
                        if (this.lastDeletedPartitionCheckMs() == 0L || now - this.lastDeletedPartitionCheckMs() >= this.config().intervalMs()) {
                            this.findDeletedPartitions();
                            this.lastDeletedPartitionCheckMs_$eq(now);
                        }
                        this.makeTransitions();
                    }
                    catch (Exception e) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Caught exception in work loop", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    break block8;
                }
                finally {
                    this.isInWorkLoop().set(false);
                }
            }
            return;
        }
    }

    private void findDeletedPartitions() {
        ObjectRef allocatedBuffer = ObjectRef.create((Object)ByteBuffer.allocate(10000));
        this.tierTopicPartitionsWithPosition().foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$1(this, allocatedBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void makeTransitions() {
        this.maybeBeginMaterialization();
        this.maybeBeginDeletion();
    }

    public Tuple2<Object, ByteBuffer> collectDeletedPartitions(TopicPartition tierTopicPartition, long startOffset, ByteBuffer allocatedBuffer) {
        Tuple2 tuple2;
        ByteBuffer buffer = allocatedBuffer;
        HostedPartition hostedPartition = this.replicaManager.getPartition(tierTopicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            AbstractLog log = ((HostedPartition.Online)hostedPartition).partition().localLogOrException();
            long lastOffset = log.highWatermark();
            LongRef currentOffset = LongRef.create((long)startOffset);
            while (currentOffset.elem < lastOffset) {
                MemoryRecords memoryRecords;
                if (!this.immigratedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition.partition()))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append(tierTopicPartition).append(" no longer hosted on this broker, stopping materialization from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
                }
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, buffer.capacity(), FetchHighWatermark$.MODULE$, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException(new StringBuilder(44).append("Unexpected tiered segment for tier topic in ").append(tierTopicPartition).toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                Records records = fetchDataInfo.records();
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    MemoryRecords memoryRecords2;
                    FileRecords fileRecords = (FileRecords)records;
                    buffer.clear();
                    if (buffer.capacity() < fileRecords.sizeInBytes()) {
                        buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
                    }
                    fileRecords.readInto(buffer, 0);
                    MemoryRecords memoryRecords3 = memoryRecords2 = new MemoryRecords(buffer);
                    memoryRecords2 = null;
                    memoryRecords = memoryRecords3;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected record type ").append(records).toString());
                }
                CollectionConverters$.MODULE$.IterableHasAsScala(memoryRecords.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$2(this, tierTopicPartition, currentOffset, batch);
                    return BoxedUnit.UNIT;
                });
                lastOffset = Math.min(lastOffset, log.highWatermark());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processed messages in ").append(tierTopicPartition).append(" from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
        } else {
            boolean bl = HostedPartition$None$.MODULE$.equals(hostedPartition) ? true : (HostedPartition$Offline$.MODULE$.equals(hostedPartition) ? true : true);
            if (bl) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)startOffset), (Object)buffer);
            } else {
                throw new MatchError((Object)hostedPartition);
            }
        }
        return tuple2;
    }

    public synchronized void maybeBeginMaterialization() {
        Iterator immigratedPartitionIt = this.immigratedPartitions().iterator();
        scala.collection.mutable.Map newDeletions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (this.capacity$1() > 0 && immigratedPartitionIt.hasNext()) {
            Tuple2 tuple2 = (Tuple2)immigratedPartitionIt.next();
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition partitionState = (ImmigratedTierTopicPartition)tuple2._2();
                if (!partitionState.inProgressDeletions().isEmpty()) continue;
                scala.collection.mutable.Map<TopicIdPartition, Object> pendingDeletions = partitionState.pendingDeletions();
                ((IterableOnceOps)pendingDeletions.take(this.capacity$1())).toList().foreach((Function1 & Serializable)x0$1 -> {
                    TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1(this, tierTopicPartitionId, partitionState, newDeletions, pendingDeletions, x0$1);
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            throw new MatchError(null);
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Beginning tier partition state materialization for ").append(newDeletions.map((Function1 & Serializable)x$5 -> (TopicIdPartition)x$5._1())).toString());
        this.tierTopicConsumer.register(CollectionConverters$.MODULE$.MutableMapHasAsJava(newDeletions).asJava());
    }

    public synchronized void maybeBeginDeletion() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable)immigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$1(this, immigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long offset) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Processing InitiateDelete for ").append(deletedPartition).append(" at offset ").append(offset).toString());
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable)tierTopicPartition -> {
            if (!tierTopicPartition.inProgressDeletions().contains((Object)deletedPartition)) {
                return tierTopicPartition.pendingDeletions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition), (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackCompletePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Processing CompleteDelete for ").append(deletedPartition).toString());
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$2(this, deletedPartition, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void reconfigure(Config proposedConfig) {
        Config currentConfig;
        Config config = currentConfig = this.config();
        if (config == null ? proposedConfig != null : !((Object)config).equals(proposedConfig)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Reconfiguring from ").append(currentConfig).append(" to ").append(proposedConfig).toString());
            long oldIntervalMs = currentConfig.intervalMs();
            long newIntervalMs = proposedConfig.intervalMs();
            this.config_$eq(proposedConfig);
            if (oldIntervalMs != newIntervalMs) {
                this.stopCoordinator();
                this.startCoordinator(0);
                return;
            }
        }
    }

    private synchronized void updateStartOffset(int tierTopicPartitionId, long newStartOffset) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable)x$6 -> {
            x$6.lastReadOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newStartOffset)));
            return BoxedUnit.UNIT;
        });
    }

    private synchronized scala.collection.immutable.Map<TopicPartition, Option<Object>> tierTopicPartitionsWithPosition() {
        return this.immigratedPartitions().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.tierTopicName(), tierTopicPartitionId)), immigratedPartition.lastReadOffset());
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void cancelInProgress(InProgressDeletion inProgressDeletion) {
        this.listener().stopPartitionDeletion(inProgressDeletion.topicIdPartition());
        inProgressDeletion.stopMaterialization();
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() - 1);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Cancelling segment deletion for ").append(inProgressDeletion.topicIdPartition()).append(" on partition emigration").toString());
        $this.cancelInProgress(inProgressDeletion);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        emigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    private final void removeMetrics$1() {
        this.removeMetric("TierNumInProgressPartitionDeletions", this.removeMetric$default$2());
        this.removeMetric("TierNumQueuedPartitionDeletions", this.removeMetric$default$2());
        this.removeMetric("HeartbeatMs", this.removeMetric$default$2());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$findDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, ObjectRef allocatedBuffer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_7;
            void var6_6;
            Option startOffsetOpt;
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            Tuple2<Object, ByteBuffer> tuple2 = $this.collectDeletedPartitions(tierTopicPartition, BoxesRunTime.unboxToLong((Object)(startOffsetOpt = (Option)x0$1._2()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), (ByteBuffer)allocatedBuffer$1.elem);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long endOffset = tuple2._1$mcJ$sp();
            ByteBuffer buffer = (ByteBuffer)tuple2._2();
            $this.updateStartOffset(tierTopicPartition.partition(), (long)var6_6);
            allocatedBuffer$1.elem = var8_7;
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$4(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        if (x0$1 instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)x0$1;
            $this.trackInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteInitiate.topicIdPartition(), record$1.offset());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)x0$1;
            $this.trackCompletePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteComplete.topicIdPartition());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$3(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbstractTierMetadata.deserialize(record.key(), record.value()))).foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$4($this, tierTopicPartition$1, record, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$2(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, LongRef currentOffset$1, MutableRecordBatch batch) {
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record);
            return BoxedUnit.UNIT;
        });
        currentOffset$1.elem = batch.nextOffset();
    }

    private final int capacity$1() {
        return this.config().maxInprogressPartitions() - this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$1(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition partitionToDelete = (TopicIdPartition)x0$1._1();
            long deleteInitiateOffset = x0$1._2$mcJ$sp();
            InProgressDeletion inProgressDeletion = new InProgressDeletion(tierTopicPartitionId$1, partitionToDelete, deleteInitiateOffset, $this.tierTopicConsumer, (scala.collection.mutable.Map<UUID, TierObjectStore.ObjectMetadata>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), InProgressDeletion$.MODULE$.$lessinit$greater$default$6(), MaterializingState$.MODULE$);
            partitionState$1.inProgressDeletions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            newDeletions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            pendingDeletions$1.remove((Object)partitionToDelete);
            $this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq($this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() + 1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        DeletionState deletionState = inProgressDeletion.deletionState();
        if (MaterializationComplete$.MODULE$.equals(deletionState)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Beginning segment deletion for ").append(inProgressDeletion.topicIdPartition()).toString());
            inProgressDeletion.awaitDeleteComplete();
            $this.listener().initiatePartitionDeletion(inProgressDeletion.topicIdPartition(), inProgressDeletion.allTieredObjects());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition immigratedPartition) {
        immigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$3(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, InProgressDeletion inProgress) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Completed deleting segments for ").append(deletedPartition$2).toString());
        $this.cancelInProgress(inProgress);
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.pendingDeletions().$minus$eq((Object)deletedPartition$2);
        immigratedTierTopicPartition.inProgressDeletions().remove((Object)deletedPartition$2).foreach((Function1 & Serializable)inProgress -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$2, inProgress);
            return BoxedUnit.UNIT;
        });
    }

    public TierDeletedPartitionsCoordinator(Scheduler scheduler, ReplicaManager replicaManager, TierTopicConsumer tierTopicConsumer, long initialIntervalMs, int initialMaxInprogressPartitions, String tierNamespace, Time time) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.tierTopicConsumer = tierTopicConsumer;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$time = time;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs = new AtomicLong(time.milliseconds());
        this.isInWorkLoop = new AtomicBoolean(false);
        this.tierTopicName = TierTopic.topicName(tierNamespace);
        this.lastDeletedPartitionCheckMs = 0L;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = 0;
        this.immigratedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.config = new Config(initialIntervalMs, initialMaxInprogressPartitions);
        this.newGauge("TierNumInProgressPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("TierNumQueuedPartitionDeletions", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.$outer.immigratedPartitions().values().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$1(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$value$1(ImmigratedTierTopicPartition x$3) {
                return x$3.pendingDeletions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.ImmigratedTierTopicPartition )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("HeartbeatMs", new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds() - this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

