/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.List;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TopicConfigSyncIncludeValidator;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;

public final class TopicConfigSyncIncludeValidator$ {
    public static final TopicConfigSyncIncludeValidator$ MODULE$ = new TopicConfigSyncIncludeValidator$();
    private static final TopicConfigSyncIncludeValidator VALIDATOR = new TopicConfigSyncIncludeValidator();

    public TopicConfigSyncIncludeValidator VALIDATOR() {
        return VALIDATOR;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> validate(List<String> value) {
        void var2_2;
        Set topicConfigs = CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().toSet();
        this.checkUnknownTopicConfigs((Set<String>)topicConfigs);
        this.checkAlwaysConfigs((Set<String>)topicConfigs);
        this.checkIndependentConfigs((Set<String>)topicConfigs);
        return var2_2;
    }

    private void checkUnknownTopicConfigs(Set<String> configs) {
        Set diff = (Set)configs.$minus$minus(MirrorTopicConfigSyncRules$.MODULE$.AllConfigs());
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(37).append("Invalid topic configs specified in ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(": ").toString()).append(new StringBuilder(42).append(diff.mkString(",")).append(". Please use the common topic config name.").toString()).toString());
        }
    }

    private void checkAlwaysConfigs(Set<String> configs) {
        Set diff = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$minus$minus(configs);
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(0).append("To make cluster linking function properly, ").append(new StringBuilder(1).append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").toString()).append(new StringBuilder(35).append("must include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",")).append(" ").toString()).append(new StringBuilder(34).append("\nThese topic configs are missing: ").append(diff.mkString(",")).toString()).toString());
        }
    }

    private void checkIndependentConfigs(Set<String> configs) {
        Set inter = (Set)configs.intersect(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs());
        if (inter.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(0).append("To make cluster linking function properly, ").append(new StringBuilder(1).append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").toString()).append(new StringBuilder(37).append("cannot include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs().mkString(",")).append(" ").toString()).append(new StringBuilder(29).append("\nRemove these topic configs: ").append(inter.mkString(",")).toString()).toString());
        }
    }

    private TopicConfigSyncIncludeValidator$() {
    }
}

