/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.FilterJson;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.utils.Logging;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkUtils$
implements Logging {
    public static final ClusterLinkUtils$ MODULE$ = new ClusterLinkUtils$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void validateLinkName(String linkName) {
        int maxLength = 200;
        if (linkName == null) {
            throw new InvalidClusterLinkException("Cluster link name is null");
        }
        if (linkName.isEmpty()) {
            throw new InvalidClusterLinkException("Cluster link name is empty");
        }
        if (linkName.equals(".") || linkName.equals("..")) {
            throw new InvalidClusterLinkException("Link name cannot be \".\" or \"..\"");
        }
        if (linkName.length() > maxLength) {
            throw new InvalidClusterLinkException(new StringBuilder(47).append("Link name exceeds maximum size of '").append(maxLength).append("' characters").toString());
        }
        if (!StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(linkName), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$validateLinkName$1(BoxesRunTime.unboxToChar((Object)c))))) {
            throw new InvalidClusterLinkException(new StringBuilder(57).append("Link name '").append(linkName).append("' is illegal, valid characters: [a-zA-Z0-9._-]").toString());
        }
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public void overrideLinkConfigsForCompatibility(Properties config) {
        MirrorTopicConfigSyncRules$.MODULE$.decorateTopicConfigSyncRules(config);
    }

    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<UUID> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo) {
        ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic;
        Option mirrorTopic = Option$.MODULE$.apply((Object)topic.mirrorTopic());
        Option option = Option$.MODULE$.apply((Object)topic.linkName());
        if (option instanceof Some) {
            ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic2;
            String linkName = (String)((Some)option).value();
            this.validateLinkName(linkName);
            if (mirrorTopic instanceof Some) {
                String string = (String)((Some)mirrorTopic).value();
                String string2 = topic.name();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new UnsupportedVersionException("Topic renaming for mirroring not yet supported.");
                }
            } else {
                if (None$.MODULE$.equals(mirrorTopic)) {
                    throw new InvalidRequestException("Mirror topic not set.");
                }
                throw new MatchError((Object)mirrorTopic);
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(41).append("Cluster link with name '").append(topic.linkName()).append("' does not exist.").toString());
            }
            MirrorTopicConfigSyncRules topicConfigSyncRules = ((ClusterLinkConfig)((Object)linkConfig.get())).topicConfigSyncRules();
            topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
            if (topicInfo instanceof Some) {
                ClusterLinkTopicInfo clusterLinkTopicInfo;
                CompletableFuture ti = (CompletableFuture)((Some)topicInfo).value();
                try {
                    if (!ti.isDone()) {
                        throw new IllegalStateException("Mirror information must have been resolved.");
                    }
                    clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (TimeoutException e) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        String string;
                        String string3 = string = "Received timeout exception while fetching topic information over cluster link";
                        string = null;
                        String msgWithLogIdent_msg = string3;
                        Object var18_15 = null;
                        this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), (Throwable)e);
                    }
                    throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                }
                ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                    throw new TopicAuthorizationException("Mirror topic creation requires READ access on the source topic.");
                }
                Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                resolveCreateTopic2 = new ClusterLinkUtils.ResolveCreateTopic(newConfigs, (Option<ClusterLinkTopicState>)new Some((Object)new ClusterLinkTopicState.Mirror(linkName, (UUID)linkId.get(), info.description().topicId(), Time.SYSTEM.milliseconds())), info.description().partitions().size());
            } else if (None$.MODULE$.equals(topicInfo)) {
                if (!validateOnly) {
                    throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                }
                resolveCreateTopic2 = new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
            } else {
                throw new MatchError(topicInfo);
            }
            resolveCreateTopic = resolveCreateTopic2;
        } else if (None$.MODULE$.equals(option)) {
            if (mirrorTopic.nonEmpty()) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
            }
            resolveCreateTopic = new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
        } else {
            throw new MatchError((Object)option);
        }
        return resolveCreateTopic;
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        if (partitions instanceof Some) {
            int n;
            CompletableFuture parts = (CompletableFuture)((Some)partitions).value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException(new StringBuilder(0).append(new StringBuilder(39).append("Cannot set '").append(numPartitions).append("' partitions for topic '").append(topic).append("', ").toString()).append(new StringBuilder(37).append("exceeds linked topic's '").append(mirrorNumPartitions).append("' partitions.").toString()).toString());
            }
        } else if (None$.MODULE$.equals(partitions)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
        } else {
            throw new MatchError(partitions);
        }
    }

    public scala.collection.immutable.Seq<ClusterLinkFilterInfo> clusterLinkFilters(Option<FilterJson> filters, Option<String> tenantPrefix) {
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1 & Serializable)x$1 -> x$1.filters()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map(arg_0 -> ClusterLinkUtils$.$anonfun$clusterLinkFilters$3(tenantPrefix, arg_0));
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        Properties properties;
        if (policy instanceof Some) {
            Properties properties2;
            AlterConfigPolicy pol = (AlterConfigPolicy)((Some)policy).value();
            Map configs = Utils.propsToStringMap((Properties)props);
            if (pol instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)pol;
                Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                properties2 = Utils.mkProperties(newConfigs);
            } else {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
                properties2 = props;
            }
            properties = properties2;
        } else if (None$.MODULE$.equals(policy)) {
            properties = props;
        } else {
            throw new MatchError(policy);
        }
        return properties;
    }

    /*
     * Unable to fully structure code
     */
    public ApiException apiException(Throwable throwable, String message) {
        var4_3 = throwable instanceof ExecutionException != false ? true : throwable instanceof CompletionException != false;
        var3_4 = var4_3 != false ? throwable.getCause() : throwable;
        v0 = err = Errors.forException((Throwable)var3_4);
        var7_6 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var7_6 != null : v0.equals(var7_6) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var8_7 = var3_4.getMessage();
        if (!(v1 != null ? v1.equals(var8_7) == false : var8_7 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = var3_4;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == var3_4 ? var3_4.getMessage() : new StringBuilder(14).append(var3_4.getMessage()).append(", root cause: ").append(rootCause).toString();
        }
        errMessage = v2;
        apiError = new ApiError(err, errMessage);
        v3 = apiError.error();
        var11_11 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var11_11) == false : var11_11 != null) && var3_4 instanceof AuthenticationException) {
            apiError = new ApiError(Errors.INVALID_CONFIG, var3_4.getMessage());
        }
        errorMessage = new StringBuilder(15).append(message).append(" due to error: ").append(apiError.messageWithFallback()).toString();
        v4 = apiError.error();
        var13_13 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var13_13) == false : var13_13 != null)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, errorMessage), var3_4);
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, errorMessage), var3_4);
        }
        return apiError.error().exception(errorMessage);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilter(Set<String> toFilter, Option<FilterJson> filterJsonObject, Option<String> tenantPrefix) {
        scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters = this.clusterLinkFilters(filterJsonObject, tenantPrefix);
        return this.doFilter(toFilter, filters);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilter(Set<String> toFilter, scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Set filtered = (Set)toFilter.filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilter$1(filters, usedFilters, item)));
        return new Tuple2((Object)filtered, filters.diff((Seq)usedFilters));
    }

    public static final /* synthetic */ boolean $anonfun$validateLinkName$1(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-';
    }

    public static final /* synthetic */ String $anonfun$resolveCreateTopic$1() {
        return "Received timeout exception while fetching topic information over cluster link";
    }

    public static final /* synthetic */ TimeoutException $anonfun$resolveCreateTopic$2(TimeoutException e$1) {
        return e$1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClusterLinkFilterInfo $anonfun$clusterLinkFilters$3(Option tenantPrefix$1, ClusterLinkFilter filter) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        patternType = SecurityUtils.patternType((String)filter.patternType());
                        if (!(tenantPrefix$1 instanceof Some)) break block6;
                        prefix = (String)((Some)tenantPrefix$1).value();
                        if (!PatternType.LITERAL.equals(patternType)) break block7;
                        v0 = filter.name();
                        var6_4 = "*";
                        if (v0 == null || !v0.equals(var6_4)) ** GOTO lbl-1000
                        v1 = patternType;
                        var7_5 = PatternType.LITERAL;
                        if (!(v1 != null ? v1.equals(var7_5) == false : var7_5 != null)) {
                            v2 = new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), filter);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
                        }
                        var3_6 = v2;
                        break block8;
                    }
                    if (PatternType.PREFIXED.equals(patternType)) {
                        var3_6 = new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
                    } else {
                        throw new IllegalStateException(new StringBuilder(24).append("Unexpected pattern type ").append(filter.patternType()).toString());
                    }
                }
                var2_7 = var3_6;
                break block9;
            }
            if (None$.MODULE$.equals(tenantPrefix$1)) {
                var2_7 = new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), filter);
            } else {
                throw new MatchError((Object)tenantPrefix$1);
            }
        }
        return var2_7;
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ boolean $anonfun$doFilter$1(scala.collection.immutable.Seq filters$1, Buffer usedFilters$1, String item) {
        scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters$1.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((IterableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isInclude()));
    }

    private ClusterLinkUtils$() {
    }
}

