/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ServiceLoader;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.CreateClusterLinkPolicy;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Source$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.Metrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkManager$ {
    public static final ClusterLinkManager$ MODULE$ = new ClusterLinkManager$();
    private static final String LocalTenantPrefixProp = "cluster.link.local.tenant.prefix";
    private static final String LinkNameProp = "cluster.link.name";
    private static volatile boolean AclSyncSupportedForConfluentPlatform = false;

    public Option<String> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public String LocalTenantPrefixProp() {
        return LocalTenantPrefixProp;
    }

    public String LinkNameProp() {
        return LinkNameProp;
    }

    public boolean AclSyncSupportedForConfluentPlatform() {
        return AclSyncSupportedForConfluentPlatform;
    }

    public void AclSyncSupportedForConfluentPlatform_$eq(boolean x$1) {
        AclSyncSupportedForConfluentPlatform = x$1;
    }

    public void ensureOnlySupportedConfigs(ClusterLinkData clusterLinkData, ClusterLinkConfig config) {
        if (config.aclSyncEnable()) {
            LinkMode linkMode = config.linkMode();
            LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
            if (!(linkMode != null && linkMode.equals(linkMode$Source$) || !clusterLinkData.tenantPrefix().isEmpty() || this.AclSyncSupportedForConfluentPlatform())) {
                throw new InvalidConfigurationException(new StringBuilder(92).append("ACL migration is not supported for cluster links in this version, '").append(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).append("' must be set to 'false'.").toString());
            }
        }
    }

    public ClientInterceptor tenantInterceptor(String localTenantPrefix, String linkName, LinkMode linkMode, Metrics metrics) {
        if (!linkName.startsWith(localTenantPrefix)) {
            throw new IllegalStateException(new StringBuilder(57).append("Tenant interceptor request for link '").append(linkName).append("' without prefix '").append(localTenantPrefix).append("''").toString());
        }
        String unprefixedLinkName = linkName.substring(localTenantPrefix.length());
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LocalTenantPrefixProp()), (Object)localTenantPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LinkNameProp()), (Object)unprefixedLinkName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)linkMode.name())}))).asJava();
        return (ClientInterceptor)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(ClientInterceptor.class)).asScala().find((Function1 & Serializable)interceptor -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManager$.$anonfun$tenantInterceptor$1(configs, metrics, interceptor))).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidClusterLinkException("Cluster link interceptor not found");
        });
    }

    public Option<CreateClusterLinkPolicy> newCreateClusterLinkPolicy() {
        try {
            return new Some((Object)((CreateClusterLinkPolicy)Class.forName("io.confluent.kafka.server.plugins.policy.CreateClusterLinkPolicy").newInstance()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return None$.MODULE$;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$tenantInterceptor$1(java.util.Map configs$1, Metrics metrics$1, ClientInterceptor interceptor) {
        try {
            interceptor.configure(configs$1);
            interceptor.configureMetrics(metrics$1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private ClusterLinkManager$() {
    }
}

