/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkScheduler;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i3Aa\u0002\u0005\u0001\u001f!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011%\u0001\u0003A!A!\u0002\u0013\ts\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u00030\u0001\u0011E\u0003\u0007C\u00035\u0001\u0011%QG\u0001\fDYV\u001cH/\u001a:MS:\\G*[:u\u001f\u001a47/\u001a;t\u0015\tI!\"\u0001\u0003mS:\\'BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0016\u001d\t\u00112#D\u0001\t\u0013\t!\u0002\"\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003-]\u0011A\u0002U3sS>$\u0017n\u0019+bg.T!\u0001\u0006\u0005\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s!\t\u0011\"$\u0003\u0002\u001c\u0011\tA2\t\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\u0019,Go\u00195fe6\u000bg.Y4feB\u0011!CH\u0005\u0003?!\u0011\u0011d\u00117vgR,'\u000fT5oW\u001a+Go\u00195fe6\u000bg.Y4fe\u0006Q\u0011N\u001c;feZ\fG.T:\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u0007%sG/\u0003\u0002)+\u0005\t\"/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0002\rqJg.\u001b;?)\u0011YC&\f\u0018\u0011\u0005I\u0001\u0001\"\u0002\r\u0005\u0001\u0004I\u0002\"\u0002\u000f\u0005\u0001\u0004i\u0002\"\u0002\u0011\u0005\u0001\u0004\t\u0013a\u0001:v]R\t\u0011\u0007\u0005\u0002#e%\u00111g\t\u0002\b\u0005>|G.Z1o\u00035A\u0017M\u001c3mK>3gm]3ugR\u0011\u0011G\u000e\u0005\u0006o\u0019\u0001\r\u0001O\u0001\u0007MV$XO]3\u0011\u0007e\n5)D\u0001;\u0015\tYD(\u0001\u0004d_6lwN\u001c\u0006\u0003\u001buR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!I\u000f\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003E\u0013.sU\"A#\u000b\u0005\u0019;\u0015\u0001B;uS2T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n\u0019Q*\u00199\u0011\u0005eb\u0015BA';\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aT,\u000f\u0005A+V\"A)\u000b\u0005I\u001b\u0016!B1e[&t'B\u0001+=\u0003\u001d\u0019G.[3oiNL!AV)\u0002#1K7\u000f^(gMN,Go\u001d*fgVdG/\u0003\u0002Y3\n)B*[:u\u001f\u001a47/\u001a;t%\u0016\u001cX\u000f\u001c;J]\u001a|'B\u0001,R\u0001")
public class ClusterLinkListOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkFetcherManager fetcherManager;

    @Override
    public boolean run() {
        ConcurrentHashMap<TopicPartition, Object> waitingPartitions = this.fetcherManager.waitingPartitions();
        if (!waitingPartitions.isEmpty()) {
            HashMap requestPartitions = new HashMap();
            ((ConcurrentHashMap.KeySetView)waitingPartitions.keySet()).forEach(tp -> requestPartitions.put(tp, new OffsetSpec.LatestSpec()));
            if (!requestPartitions.isEmpty()) {
                ListOffsetsResult result = this.clientManager.getAdmin().listOffsets(requestPartitions);
                this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleOffsets((KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>>)result.all()));
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean handleOffsets(KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> future) {
        try {
            this.fetcherManager.handleSourceOffsets((Map)future.get());
        }
        catch (Throwable e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to get offsets for topic partitions, request will be retried", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
        return true;
    }

    public ClusterLinkListOffsets(ClusterLinkClientManager clientManager, ClusterLinkFetcherManager fetcherManager, int intervalMs) {
        this.clientManager = clientManager;
        this.fetcherManager = fetcherManager;
        super(clientManager.scheduler(), "ClusterLinkListOffsets", intervalMs);
    }
}

