/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.TopicConfigSyncIncludeValidator$;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkConfig$ {
    public static final ClusterLinkConfig$ MODULE$ = new ClusterLinkConfig$();
    private static final String LinkModeProp = "link.mode";
    private static final String LinkModeDoc = new StringBuilder(102).append("Mode that indicates if this cluster is configured to be the source or destination of the cluster link.").append(new StringBuilder(19).append(" Valid values are ").append(LinkMode$.MODULE$.values().map((Function1 & Serializable)x$4 -> ((LinkMode)x$4).name())).append(".").toString()).toString();
    private static final String ConnectionModeProp = "connection.mode";
    private static final String ConnectionModeDoc = new StringBuilder(325).append("Connection mode that indicates if outbound connections are established by this cluster for").append(new StringBuilder(77).append(" the cluster link. Valid values are ").append(ConnectionMode$.MODULE$.values().map((Function1 & Serializable)x$5 -> ((ConnectionMode)x$5).name())).append(". By default, destination cluster creates").toString()).append(" outbound connections and source cluster accepts inbound connections. Connection and security configuration should be").append(" provided for the cluster that establishes outbound connections. Security configuration to establish local connections").append(new StringBuilder(88).append(" should also be provided with prefix 'local.' for source clusters with connection mode ").append(ConnectionMode$Outbound$.MODULE$.name()).append(".").toString()).toString();
    private static final String LocalPrefix = "local.";
    private static final String LocalListenerNameProp = "local.listener.name";
    private static final String LocalListenerNameDoc = new StringBuilder(97).append("Name of the local listener on the source cluster used for local cluster link connection requests.").append(new StringBuilder(68).append(" Cluster link connections are added to this listener if '").append(MODULE$.LinkModeProp()).append("=").append(LinkMode$Source$.MODULE$.name()).append("' and '").append(MODULE$.ConnectionModeProp()).append("=").append(ConnectionMode$Outbound$.MODULE$.name()).append("'.").toString()).append(new StringBuilder(120).append(" Security configuration options for creating local connections on this listener should be configured with the prefix '").append(MODULE$.LocalPrefix()).append("'.").toString()).append(" By default, the listener on which the source link was created will be used as the local listener.").toString();
    private static final String ReverseConnectionSetupTimeoutMsProp = "reverse.connection.setup.timeout.ms";
    private static final String ReverseConnectionSetupTimeoutMsDoc = "Timeout in milliseconds to wait for response of reverse connection requests for source initiated links. This limits the amount of time before a retry when brokers fail or are restarted.";
    private static final String NumClusterLinkFetchersProp = "num.cluster.link.fetchers";
    private static final String NumClusterLinkFetchersDoc = "Number of fetcher threads used to replicate messages from source brokers in cluster links.";
    private static final String RetryTimeoutMsProp = "cluster.link.retry.timeout.ms";
    private static final String RetryTimeoutMsDoc = "The number of milliseconds after which failures are no longer retried and partitions are marked as failed. If the source topic is deleted and recreated within this timeout, the link may contain records from the old as well as the new topic.";
    private static final String ClusterLinkPausedProp = "cluster.link.paused";
    private static final String ClusterLinkPausedDoc = "Whether all activity over the cluster link is paused.";
    private static final String ConsumerOffsetSyncEnableProp = "consumer.offset.sync.enable";
    private static final String ConsumerOffsetSyncEnableDoc = "Whether or not to migrate consumer offsets from the source cluster.";
    private static final String ConsumerOffsetSyncMsProp = "consumer.offset.sync.ms";
    private static final String ConsumerOffsetSyncMsDoc = "How often to sync consumer offsets.";
    private static final String ConsumerOffsetGroupFiltersProp = "consumer.offset.group.filters";
    private static final String ConsumerOffsetGroupFiltersDoc = "JSON to denote the list of consumer groups to be migrated.";
    private static final String AclSyncEnableProp = "acl.sync.enable";
    private static final String AclSyncEnableDoc = "Whether or not to migrate ACLs";
    private static final String AclFiltersProp = "acl.filters";
    private static final String AclFiltersDoc = "JSON to denote the list of ACLs to be migrated.";
    private static final String AclSyncMsProp = "acl.sync.ms";
    private static final String AclSyncMsDoc = "How often to refresh the ACLs.";
    private static final String TopicConfigSyncIncludeProp = "topic.config.sync.include";
    private static final String TopicConfigFilterDoc = "The list of topic configs to sync";
    private static final String TopicConfigSyncMsProp = "topic.config.sync.ms";
    private static final String TopicConfigSyncMsDoc = "How often to refresh the topic configs.";
    private static final String AutoMirroringEnableProp = "auto.create.mirror.topics.enable";
    private static final String AutoMirroringEnableDoc = "Whether or not to automatically create mirror topics";
    private static final String TopicFiltersProp = "auto.create.mirror.topics.filters";
    private static final String TopicFiltersDoc = "JSON to denote the list of source topics to automatically create mirror topics from";
    private static final String AvailabilityCheckMsProp = "availability.check.ms";
    private static final String AvailabilityCheckMsDoc = "How often to send a request to source cluster to check source cluster availability.";
    private static final String AvailabilityCheckConsecutiveFailureThresholdProp = "availability.check.consecutive.failure.threshold";
    private static final String AvailabilityCheckConsecutiveFailureThresholdDoc = "The upper-bound of the consecutive failures beyond which the availability checker will report the link as unavailable.";
    private static final String LinkFetcherFlowControlProp = "link.fetcher.flow.control";
    private static final String LinkFetcherFlowControlDoc = "The flow control approach used by cluster linking fetcher";
    private static final String ReplicaSocketReceiveBufferBytesDoc = "The socket receive buffer size for cluster linking connections. The receive buffer size will be limited by a defined maximum value. If set to -1, the kernel will auto tune the receive buffer size up to a defined maximum value.";
    private static final Set<String> ReplicationProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.NumClusterLinkFetchersProp(), MODULE$.RetryTimeoutMsProp(), MODULE$.LinkFetcherFlowControlProp(), KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp()}));
    private static final Set<String> PeriodicTaskProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.ConsumerOffsetSyncEnableProp(), MODULE$.ConsumerOffsetSyncMsProp(), MODULE$.ConsumerOffsetGroupFiltersProp(), MODULE$.AclSyncEnableProp(), MODULE$.AclFiltersProp(), MODULE$.AclSyncMsProp(), MODULE$.TopicConfigSyncIncludeProp(), MODULE$.TopicConfigSyncMsProp(), MODULE$.AutoMirroringEnableProp(), MODULE$.TopicFiltersProp(), MODULE$.AvailabilityCheckMsProp(), MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp()}));
    private static final Set<String> NonReconfigurableProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.LinkModeProp(), MODULE$.ConnectionModeProp()}));
    private static final ConfigDef kafka$server$link$ClusterLinkConfig$$configDef = new ConfigDef().define(MODULE$.LinkModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((IterableOnceOps)LinkMode$.MODULE$.values().map((Function1 & Serializable)x$6 -> ((LinkMode)x$6).name())).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, MODULE$.LinkModeDoc()).define(MODULE$.ConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((IterableOnceOps)((SeqOps)ConnectionMode$.MODULE$.values().map((Function1 & Serializable)x$7 -> ((ConnectionMode)x$7).name())).$colon$plus(null)).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, MODULE$.ConnectionModeDoc()).define(MODULE$.LocalListenerNameProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, MODULE$.LocalListenerNameDoc()).define(MODULE$.ReverseConnectionSetupTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(1000), (Number)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)), ConfigDef.Importance.LOW, MODULE$.ReverseConnectionSetupTimeoutMsDoc()).define(MODULE$.NumClusterLinkFetchersProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers()), ConfigDef.Importance.LOW, MODULE$.NumClusterLinkFetchersDoc()).define(MODULE$.ClusterLinkPausedProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, MODULE$.ClusterLinkPausedDoc()).define(MODULE$.ConsumerOffsetSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, MODULE$.ConsumerOffsetSyncEnableDoc()).define(MODULE$.ConsumerOffsetSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault()), ConfigDef.Importance.LOW, MODULE$.ConsumerOffsetSyncMsDoc()).define(MODULE$.ConsumerOffsetGroupFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, MODULE$.ConsumerOffsetGroupFiltersDoc()).define(MODULE$.RetryTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs()), ConfigDef.Importance.MEDIUM, MODULE$.RetryTimeoutMsDoc()).define(MODULE$.AclSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, MODULE$.AclSyncEnableDoc()).define(MODULE$.AclFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)AclJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, MODULE$.AclFiltersDoc()).define(MODULE$.AclSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault()), ConfigDef.Importance.LOW, MODULE$.AclSyncMsDoc()).define(MODULE$.TopicConfigSyncIncludeProp(), ConfigDef.Type.LIST, ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault(), (ConfigDef.Validator)TopicConfigSyncIncludeValidator$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, MODULE$.TopicFiltersDoc()).define(MODULE$.TopicConfigSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault()), ConfigDef.Importance.LOW, MODULE$.TopicConfigSyncMsDoc()).define(MODULE$.AutoMirroringEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, MODULE$.AutoMirroringEnableDoc()).define(MODULE$.TopicFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, MODULE$.TopicFiltersDoc()).define(MODULE$.AvailabilityCheckMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault()), ConfigDef.Importance.LOW, MODULE$.AvailabilityCheckMsDoc()).define(MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdDefault()), ConfigDef.Importance.LOW, MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp()).define("bootstrap.servers", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaSocketTimeoutMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsDoc()).define(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.RequestTimeoutMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.RequestTimeoutMsDoc()).define(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.ConnectionsMaxIdleMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionsMaxIdleMsDoc()).define(KafkaConfig$.MODULE$.ConnectionSetupTimeoutMsProp(), ConfigDef.Type.LONG, (Object)Defaults$.MODULE$.ConnectionSetupTimeoutMs(), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionSetupTimeoutMsDoc()).define(KafkaConfig$.MODULE$.ConnectionSetupTimeoutMaxMsProp(), ConfigDef.Type.LONG, (Object)Defaults$.MODULE$.ConnectionSetupTimeoutMaxMs(), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ConnectionSetupTimeoutMaxMsDoc()).define(KafkaConfig$.MODULE$.ReplicaSocketReceiveBufferBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaSocketReceiveBufferBytes()), ConfigDef.Importance.LOW, MODULE$.ReplicaSocketReceiveBufferBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchMaxBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchWaitMaxMs()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchBackoffMsDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.ReplicaFetchMinBytes()), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchMinBytesDoc()).define(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchResponseMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc()).define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").defineInternal(MODULE$.LinkFetcherFlowControlProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherFlowControl()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-2)), ConfigDef.Importance.LOW, MODULE$.LinkFetcherFlowControlDoc()).withClientSslSupport().withClientSaslSupport();

    public String LinkModeProp() {
        return LinkModeProp;
    }

    public String LinkModeDoc() {
        return LinkModeDoc;
    }

    public String ConnectionModeProp() {
        return ConnectionModeProp;
    }

    public String ConnectionModeDoc() {
        return ConnectionModeDoc;
    }

    public String LocalPrefix() {
        return LocalPrefix;
    }

    public String LocalListenerNameProp() {
        return LocalListenerNameProp;
    }

    public String LocalListenerNameDoc() {
        return LocalListenerNameDoc;
    }

    public String ReverseConnectionSetupTimeoutMsProp() {
        return ReverseConnectionSetupTimeoutMsProp;
    }

    public String ReverseConnectionSetupTimeoutMsDoc() {
        return ReverseConnectionSetupTimeoutMsDoc;
    }

    public String NumClusterLinkFetchersProp() {
        return NumClusterLinkFetchersProp;
    }

    public String NumClusterLinkFetchersDoc() {
        return NumClusterLinkFetchersDoc;
    }

    public String RetryTimeoutMsProp() {
        return RetryTimeoutMsProp;
    }

    public String RetryTimeoutMsDoc() {
        return RetryTimeoutMsDoc;
    }

    public String ClusterLinkPausedProp() {
        return ClusterLinkPausedProp;
    }

    public String ClusterLinkPausedDoc() {
        return ClusterLinkPausedDoc;
    }

    public String ConsumerOffsetSyncEnableProp() {
        return ConsumerOffsetSyncEnableProp;
    }

    public String ConsumerOffsetSyncEnableDoc() {
        return ConsumerOffsetSyncEnableDoc;
    }

    public String ConsumerOffsetSyncMsProp() {
        return ConsumerOffsetSyncMsProp;
    }

    public String ConsumerOffsetSyncMsDoc() {
        return ConsumerOffsetSyncMsDoc;
    }

    public String ConsumerOffsetGroupFiltersProp() {
        return ConsumerOffsetGroupFiltersProp;
    }

    public String ConsumerOffsetGroupFiltersDoc() {
        return ConsumerOffsetGroupFiltersDoc;
    }

    public String AclSyncEnableProp() {
        return AclSyncEnableProp;
    }

    public String AclSyncEnableDoc() {
        return AclSyncEnableDoc;
    }

    public String AclFiltersProp() {
        return AclFiltersProp;
    }

    public String AclFiltersDoc() {
        return AclFiltersDoc;
    }

    public String AclSyncMsProp() {
        return AclSyncMsProp;
    }

    public String AclSyncMsDoc() {
        return AclSyncMsDoc;
    }

    public String TopicConfigSyncIncludeProp() {
        return TopicConfigSyncIncludeProp;
    }

    public String TopicConfigFilterDoc() {
        return TopicConfigFilterDoc;
    }

    public String TopicConfigSyncMsProp() {
        return TopicConfigSyncMsProp;
    }

    public String TopicConfigSyncMsDoc() {
        return TopicConfigSyncMsDoc;
    }

    public String AutoMirroringEnableProp() {
        return AutoMirroringEnableProp;
    }

    public String AutoMirroringEnableDoc() {
        return AutoMirroringEnableDoc;
    }

    public String TopicFiltersProp() {
        return TopicFiltersProp;
    }

    public String TopicFiltersDoc() {
        return TopicFiltersDoc;
    }

    public String AvailabilityCheckMsProp() {
        return AvailabilityCheckMsProp;
    }

    public String AvailabilityCheckMsDoc() {
        return AvailabilityCheckMsDoc;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdProp() {
        return AvailabilityCheckConsecutiveFailureThresholdProp;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdDoc() {
        return AvailabilityCheckConsecutiveFailureThresholdDoc;
    }

    public String LinkFetcherFlowControlProp() {
        return LinkFetcherFlowControlProp;
    }

    public String LinkFetcherFlowControlDoc() {
        return LinkFetcherFlowControlDoc;
    }

    public String ReplicaSocketReceiveBufferBytesDoc() {
        return ReplicaSocketReceiveBufferBytesDoc;
    }

    public Set<String> ReplicationProps() {
        return ReplicationProps;
    }

    public Set<String> PeriodicTaskProps() {
        return PeriodicTaskProps;
    }

    public Set<String> NonReconfigurableProps() {
        return NonReconfigurableProps;
    }

    public boolean needsConnectionResetOnUpdate(String configName) {
        if (!this.configKeys().contains((Object)configName)) {
            return true;
        }
        String string = configName;
        String string2 = "security.protocol";
        return string != null && string.equals(string2) || configName.startsWith("ssl.") || configName.startsWith("sasl.");
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.kafka$server$link$ClusterLinkConfig$$configDef().toHtml());
    }

    public ConfigDef kafka$server$link$ClusterLinkConfig$$configDef() {
        return kafka$server$link$ClusterLinkConfig$$configDef;
    }

    public Seq<String> configNames() {
        return (Seq)CollectionConverters$.MODULE$.SetHasAsScala(this.kafka$server$link$ClusterLinkConfig$$configDef().names()).asScala().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public scala.collection.immutable.Map<String, ConfigDef.ConfigKey> configKeys() {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.kafka$server$link$ClusterLinkConfig$$configDef().configKeys()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<ConfigDef.Type> configType(String name) {
        return Option$.MODULE$.apply(this.kafka$server$link$ClusterLinkConfig$$configDef().configKeys().get(name)).map((Function1 & Serializable)x$8 -> x$8.type);
    }

    public void validate(Map<?, ?> props) {
        Map parsedProps = this.kafka$server$link$ClusterLinkConfig$$configDef().parse(props);
        LinkMode linkMode = LinkMode$.MODULE$.fromString((String)parsedProps.get(this.LinkModeProp()));
        String connectionMode = (String)parsedProps.get(this.ConnectionModeProp());
        String localListenerName = (String)parsedProps.get(this.LocalListenerNameProp());
        LinkMode linkMode2 = linkMode;
        LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
        if (linkMode2 != null && linkMode2.equals(linkMode$Source$)) {
            String string = connectionMode;
            String string2 = ConnectionMode$Outbound$.MODULE$.name();
            if (!(string != null ? !string.equals(string2) : string2 != null) && localListenerName == null) {
                throw new InvalidConfigurationException(new StringBuilder(60).append("'").append(this.LocalListenerNameProp()).append("' not provided for SOURCE link that establishes connections").toString());
            }
        }
        boolean aclSyncEnable = BoxesRunTime.unboxToBoolean(parsedProps.get(this.AclSyncEnableProp()));
        String aclFilters = (String)props.get(this.AclFiltersProp());
        if (aclSyncEnable && AclJson$.MODULE$.parse(aclFilters).isEmpty()) {
            throw new InvalidConfigurationException("ACL migration is enabled but acl.filters is not set. Please set acl.filters to proceed with ACL migration.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public ClusterLinkConfig create(Map<?, ?> props) {
        try {
            linkMode = (LinkMode)Option$.MODULE$.apply(props.get(this.LinkModeProp())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$create$1(java.lang.Object ), (Ljava/lang/Object;)Lkafka/server/link/LinkMode;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$create$2(), ()Lkafka/server/link/LinkMode$Destination$;)());
            v0 = props.containsKey(this.ConnectionModeProp()) != false ? ConnectionMode$.MODULE$.fromString(props.get(this.ConnectionModeProp()).toString()) : this.defaultConnectionMode(linkMode);
            var4_3 = ConnectionMode$Inbound$.MODULE$;
            if (v0 == null || !v0.equals(var4_3)) ** GOTO lbl-1000
            v1 = linkMode;
            var5_4 = LinkMode$Destination$.MODULE$;
            if (v1 != null && v1.equals(var5_4)) {
                newProps = new Properties();
                props.forEach((BiConsumer<Object, Object>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, $anonfun$create$3(java.util.Properties java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Properties)newProps));
                newProps.setProperty("bootstrap.servers", "localhost:0");
                v2 = newProps;
            } else lbl-1000:
            // 2 sources

            {
                v2 = props;
            }
            configProps = v2;
            return new ClusterLinkConfig(configProps);
        }
        catch (InvalidConfigurationException v3) {
            throw v3;
        }
        catch (ConfigException e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append((Object)e).toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append(e).toString(), (Throwable)e);
        }
    }

    public ConnectionMode defaultConnectionMode(LinkMode linkMode) {
        LinkMode linkMode2 = linkMode;
        LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
        if (linkMode2 != null && linkMode2.equals(linkMode$Destination$)) {
            return ConnectionMode$Outbound$.MODULE$;
        }
        return ConnectionMode$Inbound$.MODULE$;
    }

    public static final /* synthetic */ LinkMode $anonfun$create$1(Object m) {
        return LinkMode$.MODULE$.fromString(m.toString());
    }

    public static final /* synthetic */ LinkMode$Destination$ $anonfun$create$2() {
        return LinkMode$Destination$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$create$3(Properties newProps$1, Object k, Object v) {
        newProps$1.setProperty(k.toString(), v.toString());
    }

    private ClusterLinkConfig$() {
    }
}

